/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class LookupFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$lookup");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$lookup");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$lookup");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$lookup");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        void var3_12;
        void var3_10;
        Object var3_3 = null;
        JsonNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = LookupFunction.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            if (argObject != null && !argObject.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount < 1 || argCount > 3) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        if (!useContext) {
            argObject = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argObject == null) {
            return null;
        }
        if (argCount != 2) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        JsonNode keyObj = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (keyObj == null || !keyObj.isTextual()) {
            throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        }
        String key = keyObj.asText();
        ExpressionsVisitor.SelectorArrayNode array = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
        if (argObject.isObject()) {
            ObjectNode obj = (ObjectNode)argObject;
            LookupFunction.captureKeyValues(obj, key, array);
            if (array.size() != 1) {
                ExpressionsVisitor.SelectorArrayNode selectorArrayNode = array;
            } else {
                JsonNode jsonNode = array.get(0);
            }
        } else {
            if (!argObject.isArray()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            LookupFunction.findObjects((ArrayNode)argObject, key, array);
            if (array.size() == 0) {
                Object var3_7 = null;
            } else if (array.size() != 1) {
                ExpressionsVisitor.SelectorArrayNode selectorArrayNode = array;
            } else {
                JsonNode jsonNode = array.get(0);
            }
        }
        if (var3_10 == null || !var3_10.isArray() || var3_10.size() != 0) return var3_12;
        return var3_12;
    }

    static void findObjects(ArrayNode array, String key, ArrayNode result) {
        for (int i = 0; i < array.size(); ++i) {
            JsonNode arrayNode = array.get(i);
            if (arrayNode == null) continue;
            if (arrayNode.isArray()) {
                ArrayNode subResult = new ArrayNode(JsonNodeFactory.instance);
                LookupFunction.findObjects((ArrayNode)arrayNode, key, subResult);
                result.add(subResult);
                continue;
            }
            if (!arrayNode.isObject()) continue;
            LookupFunction.captureKeyValues((ObjectNode)arrayNode, key, result);
        }
    }

    static void captureKeyValues(ObjectNode obj, String key, ArrayNode result) {
        JsonNode value = obj.get(key);
        if (value != null) {
            result.add(value);
        }
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<x-s:x>";
    }
}

