/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;

public class AbsFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$abs");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$abs");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$abs");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        DoubleNode result = null;
        FunctionBase.CtxEvalResult ctxEvalResult = this.evalContext(expressionVisitor, ctx);
        JsonNode arg = ctxEvalResult.arg;
        int argCount = ctxEvalResult.argumentCount;
        switch (argCount) {
            case 0: {
                if (arg == null) break;
                throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
            }
            case 1: {
                if (arg == null) {
                    return null;
                }
                if (!arg.isNumber()) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                if (arg.isLong()) {
                    long number = arg.longValue();
                    if (number == Long.MIN_VALUE) {
                        result = new LongNode(Long.MAX_VALUE);
                        break;
                    }
                    result = new LongNode(Math.abs(number));
                    break;
                }
                double number = arg.doubleValue();
                result = new DoubleNode(Math.abs(number));
                break;
            }
            default: {
                if (ctx.getParent() instanceof MappingExpressionParser.Fct_chainContext) {
                    throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
                }
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<n-:n>";
    }
}

