/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.JS4JDate;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.utils.Constants;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public class FrameEnvironment
implements Serializable {
    private static final long serialVersionUID = 8451009715230117298L;
    private static final Logger LOG = Logger.getLogger(FrameEnvironment.class.getName());
    private Map<String, DeclaredFunction> _declFunctionMap = new HashMap<String, DeclaredFunction>();
    private FrameEnvironment _enclosingFrame = null;
    private boolean _isAsync = false;
    private Map<String, FunctionBase> _jsonataFunctionMap = new HashMap<String, FunctionBase>();
    private Deque<JsonNode> _stack = new LinkedList<JsonNode>();
    private JS4JDate _timestamp = null;
    private Map<String, JsonNode> _variableMap = new HashMap<String, JsonNode>();
    private Map<JsonNode, JsonNode> _parentNodeMap = null;

    public FrameEnvironment(FrameEnvironment enclosingFrame) {
        this._enclosingFrame = enclosingFrame;
        this._declFunctionMap = new HashMap<String, DeclaredFunction>();
        this._jsonataFunctionMap = new HashMap<String, FunctionBase>();
        this._variableMap = new HashMap<String, JsonNode>();
        if (enclosingFrame == null) {
            this._timestamp = new JS4JDate();
        }
    }

    public boolean async() {
        return this._isAsync;
    }

    public void clearContext() {
        if (this._enclosingFrame != null) {
            Deque<JsonNode> stack = this._enclosingFrame.getContextStack();
            stack.clear();
            return;
        }
        this._stack.clear();
    }

    public Deque<JsonNode> getContextStack() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getContextStack();
        }
        return this._stack;
    }

    public DeclaredFunction getDeclaredFunction(String fctName) {
        DeclaredFunction retFct = this._declFunctionMap.get(fctName);
        if (retFct != null || this._declFunctionMap.containsKey(fctName)) {
            return retFct;
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getDeclaredFunction(fctName);
        }
        return null;
    }

    public FunctionBase getJsonataFunction(String fctName) {
        FunctionBase fct = this._jsonataFunctionMap.get(fctName);
        if (fct != null || this._jsonataFunctionMap.containsKey(fctName)) {
            return fct;
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getJsonataFunction(fctName);
        }
        fct = Constants.FUNCTIONS.get(fctName);
        if (fct != null) {
            return fct;
        }
        return null;
    }

    public JsonNode getVariable(String varName) {
        if ("$".equals(varName)) {
            if (this.getContextStack().isEmpty()) {
                return null;
            }
            JsonNode result = this.getContextStack().peek();
            return result;
        }
        if ("$$".equals(varName)) {
            Deque<JsonNode> stack = this.getContextStack();
            if (stack.isEmpty()) {
                return null;
            }
            JsonNode result = this.getContextStack().peekLast();
            return result;
        }
        JsonNode retVar = this._variableMap.get(varName);
        if (retVar != null || this._variableMap.containsKey(varName)) {
            return retVar;
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.getVariable(varName);
        }
        return null;
    }

    public boolean isEmptyContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.isEmptyContext();
        }
        return this._stack.isEmpty();
    }

    public Long millis() {
        if (this._timestamp != null) {
            return this._timestamp.getTime();
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.millis();
        }
        return null;
    }

    public String now() {
        if (this._timestamp != null) {
            return this._timestamp.toString();
        }
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.now();
        }
        return null;
    }

    public JsonNode peekContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.peekContext();
        }
        if (this.isEmptyContext()) {
            return null;
        }
        return this._stack.peek();
    }

    public JsonNode popContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.popContext();
        }
        if (!this._stack.isEmpty()) {
            return this._stack.pop();
        }
        return null;
    }

    public JsonNode pushContext(JsonNode context) {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.pushContext(context);
        }
        this._stack.push(context);
        return context;
    }

    public void setAsync(boolean isAsync) {
        this._isAsync = isAsync;
    }

    public void setDeclaredFunction(String fctName, DeclaredFunction fctValue) throws EvaluateRuntimeException {
        if (fctName == null) {
            throw new EvaluateRuntimeException("function name is null.");
        }
        if (fctValue == null) {
            throw new EvaluateRuntimeException("function value is null.");
        }
        this._declFunctionMap.put(fctName, fctValue);
    }

    public void setJsonataFunction(String fctName, FunctionBase fctValue) throws EvaluateRuntimeException {
        if (fctName == null) {
            throw new EvaluateRuntimeException("function name is null.");
        }
        if (fctValue == null) {
            throw new EvaluateRuntimeException("function value is null.");
        }
        this._jsonataFunctionMap.put(fctName, fctValue);
    }

    public void setVariable(String varName, JsonNode varValue) throws EvaluateRuntimeException {
        if (varName == null) {
            throw new EvaluateRuntimeException("variable name is null.");
        }
        this._variableMap.put(varName, varValue);
    }

    public int sizeContext() {
        if (this._enclosingFrame != null) {
            return this._enclosingFrame.sizeContext();
        }
        return this._stack.size();
    }

    public JsonNode getParentNode(int depth) {
        int i;
        if (this._parentNodeMap == null) {
            this.initParentNodeMap();
        }
        if (this._parentNodeMap == null) {
            LOG.severe("Problem to evaluate parent path operator \"%\": could not build a parent node map.");
            return null;
        }
        JsonNode parentNode = this.getContextStack().peek();
        for (i = 0; parentNode != null && i < depth; ++i) {
            if (!((parentNode = this._parentNodeMap.get(parentNode)) instanceof ArrayNode)) continue;
            parentNode = this._parentNodeMap.get(parentNode);
        }
        if (i >= depth && parentNode == null) {
            throw new EvaluateRuntimeException("The object representing the 'parent' cannot be derived from this expression");
        }
        return parentNode;
    }

    private void initParentNodeMap() {
        if (this.getContextStack().peekLast() != null) {
            this._parentNodeMap = new IdentityHashMap<JsonNode, JsonNode>();
            this.indexNodes(this._parentNodeMap, this.getContextStack().peekLast());
        }
    }

    private void indexNodes(Map<JsonNode, JsonNode> parents, JsonNode parent) {
        block3: {
            block2: {
                if (!parent.isObject()) break block2;
                for (JsonNode child : parent) {
                    this.indexNodes(parents, child);
                    parents.put(child, parent);
                }
                break block3;
            }
            if (!parent.isArray()) break block3;
            for (JsonNode element : parent) {
                this.indexNodes(parents, element);
                parents.put(element, parent);
            }
        }
    }
}

