/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;

public class SumFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$sum");
    public static final String ERR_ARG1ARRTYPE = String.format("Argument 1 of function \"%s\" must be an array of \"number\"", "$sum");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$sum");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$sum");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode argArray = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = SumFunction.getArgumentCount(ctx);
        if (useContext) {
            argArray = FunctionUtils.getContextVariable(expressionVisitor);
            if (argArray != null && !argArray.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 1) {
            if (!useContext) {
                argArray = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
                FunctionUtils.validateArguments(ERR_ARG1ARRTYPE, expressionVisitor, ctx, 0, this.getSignature());
            }
            if (argArray == null) {
                return null;
            }
            if (argArray.isArray()) {
                ArrayNode arr = (ArrayNode)argArray;
                boolean shouldReturnAsLong = true;
                for (JsonNode a : arr) {
                    if (a.isFloatingPointNumber() || a.isDouble()) {
                        shouldReturnAsLong = false;
                        continue;
                    }
                    if (a.isIntegralNumber()) continue;
                    throw new EvaluateRuntimeException(ERR_ARG1ARRTYPE);
                }
                if (shouldReturnAsLong) {
                    long sum = 0L;
                    for (JsonNode a : arr) {
                        sum += a.asLong();
                    }
                    return new LongNode(sum);
                }
                double sum = 0.0;
                for (JsonNode a : arr) {
                    sum += a.asDouble();
                }
                return new DoubleNode(sum);
            }
            if (argArray.isIntegralNumber()) {
                return new LongNode(argArray.asLong());
            }
            if (argArray.isFloatingPointNumber() || argArray.isDouble()) {
                return new DoubleNode(argArray.asDouble());
            }
            throw new EvaluateRuntimeException(ERR_ARG1ARRTYPE);
        }
        throw new EvaluateRuntimeException(argCount == 0 ? ERR_ARG1BADTYPE : ERR_ARG2BADTYPE);
    }

    public static void main(String[] args) {
        for (double i = 0.0; i < 100.0; i += 1.0) {
            System.out.println(0.1 + i + "-" + 0.1 + " = " + (0.1 + i - 0.1));
        }
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<a<n>:n>";
    }
}

