/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.testerui;

import com.api.jsonata4java.expressions.EvaluateException;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.Expressions;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.testerui.TesterUIJsonataExample;
import com.api.jsonata4java.testerui.TesterUIPreferences;
import com.api.jsonata4java.testerui.TesterUISettings;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TesterUI {
    private Expressions expressions;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final XmlMapper xmlMapper = new XmlMapper();
    private TesterUISettings settings = new TesterUISettings();
    private final JMenuBar menuBar = new JMenuBar();
    private final JMenu menuFile = new JMenu("File");
    private final JMenuItem menuItemToJson = new JMenuItem("To JSON");
    private final JMenuItem menuItemExit = new JMenuItem("Exit");
    private final JMenu menuEdit = new JMenu("Edit");
    private final JMenuItem menuItemFormatInput = new JMenuItem("Format input");
    private final JMenu menuSettings = new JMenu("Settings");
    private final JMenuItem menuItemPreferences = new JMenuItem("Preferences...");
    private final JTextArea inputArea = new JTextArea();
    private final JTextArea jsonataArea = new JTextArea();
    private final JTextArea outputArea = new JTextArea();
    private final JScrollPane inputSp = new JScrollPane(this.inputArea);
    private final JScrollPane jsonataSp = new JScrollPane(this.jsonataArea);
    private final JScrollPane outputSp = new JScrollPane(this.outputArea);
    private final JSplitPane splitPane = new JSplitPane(1);
    private final JSplitPane splitPaneRight = new JSplitPane(0);
    private final JFrame frame = new JFrame();
    private final UndoManager undoManInput = new UndoManager();
    private final UndoManager undoManJsonata = new UndoManager();
    private static final String REDO_KEY_NAME = "redo";
    private static final String UNDO_KEY_NAME = "undo";
    private final KeyStroke undoKey = KeyStroke.getKeyStroke("control Z");
    private final KeyStroke redoKey = KeyStroke.getKeyStroke("control Y");
    private static final File INPUT_FILE_JSON = new File(TesterUISettings.SETTINGS_FOLDER, "input.json");
    private static final File INPUT_FILE_XML = new File(TesterUISettings.SETTINGS_FOLDER, "input.xml");
    private static final File JSONATA_FILE = new File(TesterUISettings.SETTINGS_FOLDER, "expression.jsonata");

    protected TesterUI() throws IOException {
        this.xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.settings.load();
        this.inputArea.setFont(this.settings.getFont());
        try {
            this.inputArea.setText(TesterUI.readFile(this.settings.getPathInput()));
        }
        catch (NoSuchFileException e) {
            try {
                this.inputArea.setText(TesterUI.readFile(TesterUISettings.DEFAULT_PATH_INPUT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jsonataArea.setFont(this.settings.getFont());
        try {
            this.jsonataArea.setText(TesterUI.readFile(this.settings.getPathJsonata()));
        }
        catch (NoSuchFileException e) {
            this.jsonataArea.setText(TesterUI.readFile(TesterUISettings.DEFAULT_PATH_JSONATA));
        }
        this.outputArea.setFont(this.settings.getFont());
        this.outputArea.setEditable(false);
        this.inputSp.setMinimumSize(new Dimension(400, 0));
        this.jsonataSp.setMinimumSize(new Dimension(0, 50));
        this.splitPane.add(this.inputSp);
        this.splitPaneRight.add(this.jsonataSp);
        this.splitPaneRight.add(this.outputSp);
        this.splitPane.add(this.splitPaneRight);
        this.frame.setTitle("JSONata4Java Tester UI");
        this.frame.getContentPane().add(this.splitPane);
        this.frame.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menuFile);
        this.menuFile.add(this.menuItemExit);
        this.menuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUI.this.exit();
            }
        });
        this.menuBar.add(this.menuEdit);
        this.menuEdit.add(this.menuItemFormatInput);
        this.menuItemFormatInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUI.this.formatInput();
            }
        });
        this.menuEdit.add(this.menuItemToJson);
        this.menuItemToJson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUI.this.inputToJson();
            }
        });
        this.menuBar.add(this.menuSettings);
        this.menuSettings.add(this.menuItemPreferences);
        this.menuItemPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUI.this.showPreferences();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TesterUI.this.exit();
            }
        });
        Integer frameSizeX = this.settings.getFrameSizeX();
        Integer frameSizeY = this.settings.getFrameSizeY();
        if (frameSizeX != null && frameSizeY != null) {
            this.frame.setSize(new Dimension(frameSizeX, frameSizeY));
        } else {
            Dimension screendim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension windim = new Dimension(screendim.getWidth() > 1500.0 ? 1500 : (int)(screendim.getWidth() / 2.0), screendim.getHeight() > 800.0 ? 800 : (int)(screendim.getHeight() / 2.0));
            this.frame.setSize(windim);
        }
        this.frame.setLocation(100, 100);
        if (this.settings.getSpiltPaneDivLocation() != null) {
            this.splitPane.setDividerLocation(this.settings.getSpiltPaneDivLocation());
        }
        if (this.settings.getSpiltPaneDivLocationRight() != null) {
            this.splitPaneRight.setDividerLocation(this.settings.getSpiltPaneDivLocationRight());
        }
        this.parseMappingDescription();
        this.map();
        this.makeUndoable(this.inputArea, this.undoManInput);
        this.makeUndoable(this.jsonataArea, this.undoManJsonata);
        this.listenToInputChanges();
        this.listenToJsonataChanges();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TesterUI.this.settings.getScrollPositionInputY() != null) {
                    TesterUI.this.inputSp.getVerticalScrollBar().setValue(TesterUI.this.settings.getScrollPositionInputY());
                }
                if (TesterUI.this.settings.getScrollPositionJsonataY() != null) {
                    TesterUI.this.jsonataSp.getVerticalScrollBar().setValue(TesterUI.this.settings.getScrollPositionJsonataY());
                }
                if (TesterUI.this.settings.getScrollPositionOutputY() != null) {
                    TesterUI.this.outputSp.getVerticalScrollBar().setValue(TesterUI.this.settings.getScrollPositionOutputY());
                }
            }
        });
    }

    private void listenToInputChanges() {
        this.inputArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TesterUI.this.inputChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TesterUI.this.inputChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TesterUI.this.inputChanged();
            }
        });
    }

    private void listenToJsonataChanges() {
        this.jsonataArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TesterUI.this.jsonataChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TesterUI.this.jsonataChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TesterUI.this.jsonataChanged();
            }
        });
    }

    private void makeUndoable(JTextArea area, final UndoManager undoManager) {
        area.getDocument().addUndoableEditListener(event -> undoManager.addEdit(event.getEdit()));
        area.getActionMap().put(UNDO_KEY_NAME, new AbstractAction(UNDO_KEY_NAME){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        area.getInputMap().put(this.undoKey, UNDO_KEY_NAME);
        area.getActionMap().put(REDO_KEY_NAME, new AbstractAction(REDO_KEY_NAME){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        area.getInputMap().put(this.redoKey, REDO_KEY_NAME);
    }

    private void inputToJson() {
        try {
            switch (this.getFormat(this.inputArea.getText())) {
                case XML: {
                    this.inputArea.setText(this.jsonMapper.writeValueAsString(this.xmlMapper.readTree(this.inputArea.getText())));
                    break;
                }
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private void exit() {
        try {
            this.settings.ensureSettingsFolder();
            switch (this.getFormat(this.inputArea.getText())) {
                case XML: {
                    Files.write(INPUT_FILE_XML.toPath(), this.inputArea.getText().getBytes(), new OpenOption[0]);
                    this.settings.setPathInput(INPUT_FILE_XML.toPath());
                    break;
                }
                default: {
                    Files.write(INPUT_FILE_JSON.toPath(), this.inputArea.getText().getBytes(), new OpenOption[0]);
                    this.settings.setPathInput(INPUT_FILE_JSON.toPath());
                }
            }
            Files.write(JSONATA_FILE.toPath(), this.jsonataArea.getText().getBytes(), new OpenOption[0]);
            this.settings.setPathJsonata(JSONATA_FILE.toPath());
            this.settings.setExample(TesterUIJsonataExample.fromContent(this.inputArea.getText(), this.jsonataArea.getText()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.settings.setFrameSizeX(this.frame.getSize().getSize().width);
        this.settings.setFrameSizeY(this.frame.getSize().getSize().height);
        this.settings.setSpiltPaneDivLocation(this.splitPane.getDividerLocation());
        this.settings.setSpiltPaneDivLocationRight(this.splitPaneRight.getDividerLocation());
        this.settings.setScrollPositionInputY(this.inputSp.getVerticalScrollBar().getValue());
        this.settings.setScrollPositionJsonataY(this.jsonataSp.getVerticalScrollBar().getValue());
        this.settings.setScrollPositionOutputY(this.outputSp.getVerticalScrollBar().getValue());
        this.settings.store();
        System.out.println("Bye bye");
        System.exit(0);
    }

    private void formatInput() {
        try {
            switch (this.getFormat(this.inputArea.getText())) {
                case XML: {
                    this.inputArea.setText(this.xmlMapper.writeValueAsString(this.xmlMapper.readTree(this.inputArea.getText())));
                    break;
                }
                default: {
                    this.inputArea.setText(this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.jsonMapper.readTree(this.inputArea.getText())));
                    break;
                }
            }
        }
        catch (JsonProcessingException e) {
            System.err.println("Input error: " + e.getMessage());
            this.outputArea.setText("Input error: " + e.getMessage());
            this.inputArea.setBackground(this.settings.getBackgroundError());
            this.outputArea.setBackground(this.settings.getBackgroundError());
        }
    }

    private void showPreferences() {
        new TesterUIPreferences(this, this.settings).open();
    }

    private void inputChanged() {
        if (this.expressions != null || this.parseMappingDescription()) {
            this.map();
            this.settings.setExample(TesterUIJsonataExample.NONE);
        }
    }

    private void jsonataChanged() {
        if (this.parseMappingDescription()) {
            this.map();
            this.settings.setExample(TesterUIJsonataExample.NONE);
        }
    }

    private boolean parseMappingDescription() {
        String mappingDescription = this.jsonataArea.getText();
        if (mappingDescription.length() == 0) {
            return false;
        }
        try {
            this.expressions = Expressions.parse(mappingDescription);
            return true;
        }
        catch (ParseException | IOException | RuntimeException e) {
            System.err.println("JSONata syntax error: " + e.getMessage());
            this.outputArea.setText("JSONata syntax error: " + e.getMessage());
            this.jsonataArea.setBackground(this.settings.getBackgroundError());
            this.outputArea.setBackground(this.settings.getBackgroundError());
            this.expressions = null;
            return false;
        }
    }

    private void map() {
        JsonNode inNode = null;
        if (this.inputArea.getText().length() != 0) {
            if (this.inputArea.getText().matches("^[ \n\t]+$")) {
                this.outputArea.setText("Input error: Unexpected end of JSON input");
                this.inputArea.setBackground(this.settings.getBackgroundError());
                this.outputArea.setBackground(this.settings.getBackgroundError());
                return;
            }
            try {
                switch (this.getFormat(this.inputArea.getText())) {
                    case XML: {
                        inNode = this.xmlMapper.readTree(this.inputArea.getText());
                        break;
                    }
                    default: {
                        inNode = this.jsonMapper.readTree(this.inputArea.getText());
                        break;
                    }
                }
            }
            catch (JsonProcessingException | RuntimeException e) {
                System.err.println("Input error: " + e.getMessage());
                this.outputArea.setText("Input error: " + e.getMessage());
                this.inputArea.setBackground(this.settings.getBackgroundError());
                this.outputArea.setBackground(this.settings.getBackgroundError());
                return;
            }
        }
        try {
            JsonNode outNode = this.expressions.evaluate(inNode);
            String newOutput = this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(outNode);
            if (newOutput == null || newOutput.trim().equals("null")) {
                newOutput = "** no match **";
            }
            final int outputScrollPosBefore = this.outputSp.getVerticalScrollBar().getValue();
            this.outputArea.setText(newOutput);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TesterUI.this.outputSp.getVerticalScrollBar().setValue(outputScrollPosBefore);
                }
            });
            System.out.println("Mapped successfully");
            this.inputArea.setBackground(this.settings.getBackgroundInput());
            this.jsonataArea.setBackground(this.settings.getBackgroundJsonata());
            this.outputArea.setBackground(this.settings.getBackgroundOutput());
        }
        catch (EvaluateException | EvaluateRuntimeException e) {
            System.err.println("JSONata mapping error: " + e.getMessage());
            this.outputArea.setText(e.getMessage());
            this.jsonataArea.setBackground(this.settings.getBackgroundError());
            this.outputArea.setBackground(this.settings.getBackgroundError());
        }
        catch (JsonProcessingException | RuntimeException e) {
            System.err.println("JSONata mapping error: " + e.getMessage());
            this.outputArea.setText("JSONata mapping error: " + e.getMessage());
            this.jsonataArea.setBackground(this.settings.getBackgroundError());
            this.outputArea.setBackground(this.settings.getBackgroundError());
        }
    }

    private Format getFormat(String text) {
        if (text.trim().startsWith("<")) {
            return Format.XML;
        }
        return Format.JSON;
    }

    protected static String readFile(Path filePath) throws IOException {
        byte[] bytes = Files.readAllBytes(filePath);
        String s = new String(bytes, StandardCharsets.UTF_8);
        return s;
    }

    protected String jsonToXml(String json) throws IOException {
        JsonNode node = this.jsonMapper.readValue(json, JsonNode.class);
        this.xmlMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        this.xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_1_1, true);
        ObjectWriter ow = this.xmlMapper.writer().withRootName("root");
        StringWriter w = new StringWriter();
        ow.writeValue(w, (Object)node);
        return w.toString();
    }

    protected String xmlToJson(String xml) throws IOException {
        JsonNode node = this.xmlMapper.readTree(xml.getBytes());
        return this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(node);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TesterUI ui = new TesterUI();
                    ui.frame.setVisible(true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void loadInput(Path path) {
        try {
            this.inputArea.setText(TesterUI.readFile(path));
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadJsonata(Path path) {
        try {
            this.jsonataArea.setText(TesterUI.readFile(path));
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setBackgroundInput(Color color) {
        this.inputArea.setBackground(color);
    }

    public void setBackgroundJsonata(Color color) {
        this.jsonataArea.setBackground(color);
    }

    public void setBackgroundOutput(Color color) {
        this.outputArea.setBackground(color);
    }

    public void setFont(Font font) {
        this.inputArea.setFont(font);
        this.jsonataArea.setFont(font);
        this.outputArea.setFont(font);
    }

    static enum Format {
        XML,
        JSON;

    }
}

