/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions;

import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.tree.ParseTree;

public class OrderByOperator {
    private JsonNodeFactory factory = JsonNodeFactory.instance;

    public ArrayNode evaluate(MappingExpressionParser.Op_orderbyContext ctx, ArrayNode in) {
        return this.orderBy(in, this.extractOrderByFields(ctx));
    }

    private ArrayNode orderBy(ArrayNode in, final List<OrderByField> sortFields) {
        ArrayList<JsonNode> jsonNodes = new ArrayList<JsonNode>();
        Iterator<JsonNode> iter = in.elements();
        while (iter.hasNext()) {
            jsonNodes.add(iter.next());
        }
        Collections.sort(jsonNodes, new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                for (OrderByField sortField : sortFields) {
                    int comp;
                    JsonNode n1 = o1.get(sortField.name);
                    JsonNode n2 = o2.get(sortField.name);
                    if (n1 == null || n2 == null) continue;
                    if (n1 instanceof TextNode && n2 instanceof TextNode && (comp = ((TextNode)n1).asText().compareTo(((TextNode)n2).asText())) != 0) {
                        return sortField.order == OrderByOrder.DESC ? comp * -1 : comp;
                    }
                    if (n1 instanceof NumericNode && n2 instanceof NumericNode && (comp = Double.compare(((NumericNode)n1).asDouble(), ((NumericNode)n2).asDouble())) != 0) {
                        return sortField.order == OrderByOrder.DESC ? comp * -1 : comp;
                    }
                    if (!(n1 instanceof BooleanNode) || !(n2 instanceof BooleanNode) || (comp = Boolean.compare(((BooleanNode)n1).asBoolean(), ((BooleanNode)n2).asBoolean())) == 0) continue;
                    return sortField.order == OrderByOrder.DESC ? comp * -1 : comp;
                }
                return 0;
            }
        });
        return new ArrayNode(this.factory, jsonNodes);
    }

    private List<OrderByField> extractOrderByFields(MappingExpressionParser.Op_orderbyContext ctx) {
        OrderByOrder defaultOrder;
        ArrayList<OrderByField> sortFields = new ArrayList<OrderByField>();
        int cnt = ctx.getChildCount();
        OrderByOrder order = defaultOrder = OrderByOrder.ASC;
        block5: for (int i = 0; i < cnt; ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(child.getPayload() instanceof CommonToken)) continue;
            CommonToken token = (CommonToken)child.getPayload();
            switch (token.getType()) {
                case 48: {
                    sortFields.add(new OrderByField(token.getText(), order));
                    order = defaultOrder;
                    continue block5;
                }
                case 39: {
                    order = OrderByOrder.DESC;
                    continue block5;
                }
                case 37: {
                    order = OrderByOrder.ASC;
                }
            }
        }
        return sortFields;
    }

    static enum OrderByOrder {
        ASC,
        DESC;

    }

    class OrderByField {
        public final String name;
        public final OrderByOrder order;

        public OrderByField(String name, OrderByOrder order) {
            this.name = name;
            this.order = order;
        }
    }
}

