/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;

public class SpreadFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$spread");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$spread");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$spread");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$spread");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = JsonNodeFactory.instance.arrayNode();
        JsonNode argObject = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = SpreadFunction.getArgumentCount(ctx);
        if (useContext) {
            argObject = FunctionUtils.getContextVariable(expressionVisitor);
            if (argObject != null && !argObject.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        boolean[] argIsArray = new boolean[]{false};
        if (argCount <= 2) {
            MappingExpressionParser.ExprContext exprCtx;
            argObject = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            if (argObject == null && (exprCtx = ctx.exprValues().exprList().expr(0)) instanceof MappingExpressionParser.Function_declContext) {
                argObject = new TextNode("");
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        }
        result = this.spread((ArrayNode)result, argObject, argIsArray);
        if (result != null && !argIsArray[0]) {
            JsonNode test = ExpressionsVisitor.unwrapArray(result);
            if (test.isArray() && test instanceof ExpressionsVisitor.SelectorArrayNode) {
                result = (ExpressionsVisitor.SelectorArrayNode)test;
            } else {
                return test;
            }
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<x-:a<o>";
    }

    public ArrayNode addObject(ArrayNode result, ObjectNode obj) {
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result = this.concat(result, cell);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonNode spread(ArrayNode result, JsonNode argObject, boolean[] argIsArray) {
        if (argObject == null) {
            return null;
        }
        if (argObject.isObject()) {
            ObjectNode obj = (ObjectNode)argObject;
            if (obj.size() <= 0) return null;
            return this.addObject(result, obj);
        }
        if (!argObject.isArray()) return this.concat(result, argObject);
        argIsArray[0] = true;
        ArrayNode objArray = (ArrayNode)argObject;
        if (objArray.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < objArray.size()) {
            JsonNode node = objArray.get(i);
            if (node.isObject()) {
                ObjectNode obj = (ObjectNode)node;
                result = this.addObject(result, obj);
            } else if (node.isArray()) {
                for (JsonNode elt : (ArrayNode)node) {
                    result = (ArrayNode)this.append(result, this.spread(result, elt, argIsArray));
                }
            } else {
                result = this.concat(result, node);
            }
            ++i;
        }
        return result;
    }

    JsonNode append(JsonNode base, JsonNode appendage) {
        if (base == null) {
            return appendage;
        }
        if (appendage == null) {
            return base;
        }
        if (!base.isArray()) {
            ExpressionsVisitor.SelectorArrayNode newBase = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
            newBase.add(base);
            base = newBase;
        }
        if (!appendage.isArray()) {
            ArrayNode newAppendage = JsonNodeFactory.instance.arrayNode();
            newAppendage.add(appendage);
            appendage = newAppendage;
        }
        return this.concat((ArrayNode)base, appendage);
    }

    ArrayNode concat(ArrayNode base, JsonNode appendage) {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        for (JsonNode elt : base) {
            result.add(elt);
        }
        if (appendage.isArray()) {
            result.removeAll();
            for (JsonNode elt : appendage) {
                result.add(elt);
            }
        } else {
            result.add(appendage);
        }
        return result;
    }
}

