/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.core;

import com.mdfromhtml.core.MDfromHTMLUtils;
import java.io.Serializable;

public class MDfromHTMLBASE64Codec
implements Serializable {
    private static final long serialVersionUID = 2712028472437499003L;
    static boolean bDebugFlag = false;
    static int LINE_LEN = 76;
    public static final String val_safe = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=");
    static final String val_str = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
    static final byte[] b64Digits = val_str.getBytes();
    static final byte[] b64SafeDigits = val_safe.getBytes();
    static int PAD_OFFSET = b64Digits.length - 1;

    public static byte[] decode(String strEncoded) {
        return MDfromHTMLBASE64Codec.decode(strEncoded, false);
    }

    public static byte[] decode(String strEncoded, boolean bURLSafe) {
        int iPADIndex;
        if (strEncoded == null) {
            return new byte[0];
        }
        byte[] bEncoded = strEncoded.getBytes();
        int iLen = bEncoded.length;
        if (bDebugFlag) {
            System.out.println("[base64]decode received string " + iLen + " bytes long:");
            System.out.println(strEncoded);
        }
        if ((iPADIndex = strEncoded.indexOf(b64Digits[PAD_OFFSET])) > 0) {
            iLen = iPADIndex;
        }
        int iNLCount = 0;
        int iNLIndex = 0;
        while (iNLIndex < iLen) {
            if (bEncoded[iNLIndex++] != 10) continue;
            ++iNLCount;
        }
        if (bDebugFlag) {
            System.out.println("[base64]decode found " + iNLCount + " embedded newlines:");
        }
        if (iLen - iNLCount == 0) {
            return new byte[0];
        }
        int iOutLen = (iLen - iNLCount) * 3 / 4;
        if (bDebugFlag) {
            System.out.println("[base64]decode output length is " + iOutLen);
        }
        if (iOutLen == 0) {
            return new byte[0];
        }
        byte[] bOut = new byte[iOutLen];
        byte[] bWork = new byte[4];
        int iWorkOffset = 0;
        int iOutputOffset = 0;
        int i = 0;
        for (i = 0; i < iLen; ++i) {
            if (bEncoded[i] == 10) continue;
            if (bEncoded[i] == b64Digits[PAD_OFFSET]) {
                iOutputOffset = MDfromHTMLBASE64Codec.fromBASE64(bWork, iWorkOffset, bOut, iOutputOffset);
                break;
            }
            bWork[iWorkOffset++] = bEncoded[i];
            if (iWorkOffset != 4) continue;
            iOutputOffset = MDfromHTMLBASE64Codec.fromBASE64(bWork, iWorkOffset, bOut, iOutputOffset);
            iWorkOffset = 0;
            bWork[0] = 0;
            bWork[1] = 0;
            bWork[2] = 0;
            bWork[3] = 0;
        }
        if (iWorkOffset > 0 && i > 0 && bEncoded[i - 1] != b64Digits[PAD_OFFSET]) {
            iOutputOffset = MDfromHTMLBASE64Codec.fromBASE64(bWork, iWorkOffset, bOut, iOutputOffset);
        }
        return bOut;
    }

    public static String encode(byte[] bArray) {
        return MDfromHTMLBASE64Codec.encode(bArray, false);
    }

    public static String encode(byte[] bArray, boolean bURLSafe) {
        if (bArray == null) {
            return "";
        }
        int iLen = bArray.length;
        if (iLen == 0) {
            return "";
        }
        int iOutLen = (iLen * 4 + 2) / 3;
        if (iOutLen % 4 != 0) {
            iOutLen += 4 - iOutLen % 4;
        }
        int iNLCount = iOutLen / LINE_LEN;
        int[] nlMgr = new int[1];
        byte[] bOut = new byte[iOutLen += iNLCount];
        byte[] bWork = new byte[3];
        int iWorkOffset = 0;
        int iOutputOffset = 0;
        for (int i = 0; i < iLen; ++i) {
            bWork[iWorkOffset++] = bArray[i];
            if (iWorkOffset != 3) continue;
            iOutputOffset = MDfromHTMLBASE64Codec.toBASE64(bWork, iWorkOffset, bOut, iOutputOffset, nlMgr, bURLSafe);
            iWorkOffset = 0;
        }
        if (iWorkOffset != 0) {
            iOutputOffset = MDfromHTMLBASE64Codec.toBASE64(bWork, iWorkOffset, bOut, iOutputOffset, nlMgr, bURLSafe);
        }
        return new String(bOut);
    }

    static int fromBASE64(byte[] bWork, int iWorkOffset, byte[] bOut, int iOutputOffset) {
        byte b1 = MDfromHTMLBASE64Codec.getBASE64index(bWork[0]);
        byte b2 = MDfromHTMLBASE64Codec.getBASE64index(bWork[1]);
        byte b3 = MDfromHTMLBASE64Codec.getBASE64index(bWork[2]);
        byte b4 = MDfromHTMLBASE64Codec.getBASE64index(bWork[3]);
        if (iWorkOffset >= 0) {
            bOut[iOutputOffset] = (byte)(b1 << 2);
            int n = iOutputOffset++;
            bOut[n] = (byte)(bOut[n] | (byte)((b2 & 0x30) >> 4 & 3));
        }
        if (iWorkOffset >= 1 && iOutputOffset < bOut.length) {
            bOut[iOutputOffset] = (byte)((b2 & 0xF) << 4 & 0xF0);
            int n = iOutputOffset++;
            bOut[n] = (byte)(bOut[n] | (byte)((b3 & 0x3C) >> 2 & 0xF));
        }
        if (iWorkOffset >= 2 && iOutputOffset < bOut.length) {
            bOut[iOutputOffset] = (byte)((b3 & 3) << 6 & 0xC0);
            int n = iOutputOffset++;
            bOut[n] = (byte)(bOut[n] | b4);
        }
        return iOutputOffset;
    }

    static byte getBASE64index(byte bIn) {
        if (bIn >= 65 && bIn <= 90) {
            return (byte)(bIn - 65);
        }
        if (bIn >= 97 && bIn <= 122) {
            return (byte)(bIn - 71);
        }
        if (bIn >= 48 && bIn <= 57) {
            return (byte)(bIn + 4);
        }
        if (bIn == 43) {
            return 62;
        }
        if (bIn == 47) {
            return 63;
        }
        if (bIn == 45) {
            return 62;
        }
        if (bIn == 95) {
            return 63;
        }
        return 0;
    }

    public static void main(String[] args) {
        String strTest = "passw0rd";
        strTest = args.length > 0 ? args[0] : MDfromHTMLUtils.prompt("Enter text to be converted:");
        byte[] testBytes = strTest.getBytes();
        String strEncoded = MDfromHTMLBASE64Codec.encode(testBytes, true);
        System.out.println(strTest + "=" + strEncoded);
        byte[] decoded = MDfromHTMLBASE64Codec.decode(strEncoded, true);
        String strDecoded = new String(decoded);
        System.out.println(strDecoded);
        strTest = MDfromHTMLUtils.prompt("Enter text to be decoded:");
        decoded = MDfromHTMLBASE64Codec.decode(strTest, true);
        strDecoded = new String(decoded);
        System.out.println(strDecoded);
    }

    static int toBASE64(byte[] bWork, int iWorkOffset, byte[] bOut, int iOutputOffset, int[] nlMgr, boolean bURLSafe) {
        int iBASE64Offset = 0;
        if (iWorkOffset >= 0) {
            iBASE64Offset = (bWork[0] & 0xFC) >> 2 & 0x3F;
            bOut[iOutputOffset++] = bURLSafe ? b64SafeDigits[iBASE64Offset] : b64Digits[iBASE64Offset];
            nlMgr[0] = nlMgr[0] + 1;
            if (nlMgr[0] % LINE_LEN == 0) {
                bOut[iOutputOffset++] = 10;
            }
        }
        if (iWorkOffset >= 1) {
            iBASE64Offset = (bWork[0] & 3) << 4;
            bOut[iOutputOffset++] = bURLSafe ? b64SafeDigits[iBASE64Offset] : b64Digits[iBASE64Offset |= (bWork[1] & 0xF0) >> 4 & 0xF];
            nlMgr[0] = nlMgr[0] + 1;
            if (nlMgr[0] % LINE_LEN == 0) {
                bOut[iOutputOffset++] = 10;
            }
        }
        if (iWorkOffset >= 2) {
            iBASE64Offset = (bWork[1] & 0xF) << 2 & 0x3C;
            bOut[iOutputOffset++] = bURLSafe ? b64SafeDigits[iBASE64Offset] : b64Digits[iBASE64Offset |= (bWork[2] & 0xC0) >> 6 & 3];
            nlMgr[0] = nlMgr[0] + 1;
            if (nlMgr[0] % LINE_LEN == 0) {
                bOut[iOutputOffset++] = 10;
            }
        } else {
            bOut[iOutputOffset++] = b64Digits[PAD_OFFSET];
            nlMgr[0] = nlMgr[0] + 1;
            if (nlMgr[0] % LINE_LEN == 0) {
                bOut[iOutputOffset++] = 10;
            }
        }
        if (iWorkOffset >= 3) {
            iBASE64Offset = bWork[2] & 0x3F;
            bOut[iOutputOffset++] = bURLSafe ? b64SafeDigits[iBASE64Offset] : b64Digits[iBASE64Offset];
            nlMgr[0] = nlMgr[0] + 1;
            if (nlMgr[0] % LINE_LEN == 0) {
                bOut[iOutputOffset++] = 10;
            }
        } else {
            bOut[iOutputOffset++] = b64Digits[PAD_OFFSET];
            nlMgr[0] = nlMgr[0] + 1;
            if (nlMgr[0] % LINE_LEN == 0) {
                bOut[iOutputOffset++] = 10;
            }
        }
        bWork[0] = 0;
        bWork[1] = 0;
        bWork[2] = 0;
        return iOutputOffset;
    }
}

