/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.core;

import com.api.json.JSON;
import com.api.json.JSONArray;
import com.api.json.JSONArtifact;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLConstants;
import com.mdfromhtml.core.MDfromHTMLDate;
import com.mdfromhtml.core.MDfromHTMLPropertyManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.management.modelmbean.InvalidTargetObjectTypeException;

public class MDfromHTMLUtils
implements Serializable {
    public static final int iDayMilliseconds = 86400000;
    public static final int iHourMilliseconds = 3600000;
    public static final int iMinuteMilliseconds = 60000;
    private static final long serialVersionUID = 8109772978213632637L;
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static String arrayListToListString(ArrayList<?> list) {
        if (list == null || list.size() == 0) {
            return "{}";
        }
        String strDelimiter = ",";
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Object item = null;
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(strDelimiter);
            }
            if ((item = (Object)list.get(i)) instanceof Integer) {
                sb.append(item.toString());
                continue;
            }
            if (item instanceof Long) {
                sb.append(item.toString());
                continue;
            }
            if (item instanceof Double) {
                sb.append(item.toString());
                continue;
            }
            if (item instanceof Float) {
                sb.append(item.toString());
                continue;
            }
            if (item instanceof String) {
                sb.append("\"");
                sb.append(item.toString());
                sb.append("\"");
                continue;
            }
            sb.append("\"");
            sb.append(item.toString());
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static char[] byteToHexChars(byte bIn) {
        char[] cOut = new char[2];
        int iMasker = bIn & 0xFF;
        int iMaskerHigh = iMasker & 0xF0;
        int iMaskerLow = iMasker & 0xF;
        iMaskerHigh = (iMaskerHigh >>= 4) > 9 ? iMaskerHigh + 65 - 10 : (iMaskerHigh += 48);
        iMaskerLow = iMaskerLow > 9 ? iMaskerLow + 65 - 10 : (iMaskerLow += 48);
        cOut[0] = (char)iMaskerHigh;
        cOut[1] = (char)iMaskerLow;
        return cOut;
    }

    public static boolean checkWordFilter(String word) {
        if (word == null) {
            return true;
        }
        if ((word = word.trim()).length() == 0) {
            return true;
        }
        if (word.contains("@")) {
            return true;
        }
        if (word.toLowerCase().contains("http")) {
            return true;
        }
        char wordChar = word.charAt(0);
        if ('0' <= wordChar && wordChar <= '9') {
            return true;
        }
        wordChar = word.charAt(word.length() - 1);
        return '0' <= wordChar && wordChar <= '9';
    }

    public static String cleanseHTMLTagsFromText(String text) {
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        text = text.toLowerCase();
        text = text.replaceAll("\n", " ");
        text = text.replaceAll("\r", " ");
        text = text.replaceAll("\\<ul\\>", " ");
        text = text.replaceAll("\\</ul\\>", " ");
        text = text.replaceAll("\\<br\\>", " ");
        text = text.replaceAll("\\</br\\>", " ");
        text = text.replaceAll("\\<br/\\>", " ");
        text = text.replaceAll("\\<li\\>", " ");
        text = text.replaceAll("\\</li\\>", " ");
        text = text.replaceAll("\\<acc\\-body\\>", " ");
        text = text.replaceAll("\\</acc\\-body\\>", " ");
        text = text.replaceAll("\\<acc\\-header\\>", " ");
        text = text.replaceAll("\\</acc\\-header\\>", " ");
        text = text.replaceAll("\\</a\\>", " ");
        text = text.replaceAll("\\<b\\>", " ");
        text = text.replaceAll("\\</b\\>", " ");
        text = text.replaceAll("\\<i\\>", " ");
        text = text.replaceAll("\\</i\\>", " ");
        text = text.replaceAll("\\<p\\>", " ");
        text = text.replaceAll("\\</p\\>", " ");
        text = text.replaceAll("\\<ol\\>", " ");
        text = text.replaceAll("\\</ol\\>", " ");
        text = text.replaceAll("\\<strong\\>", " ");
        text = text.replaceAll("\\</strong\\>", " ");
        text = text.replaceAll("\\<big\\>", " ");
        text = text.replaceAll("\\</big\\>", " ");
        text = text.replaceAll("\\<font\\>", " ");
        text = text.replaceAll("\\</font\\>", " ");
        text = text.replaceAll("\\<u\\>", " ");
        text = text.replaceAll("\\</u\\>", " ");
        text = text.replaceAll("\\<span\\>", " ");
        text = text.replaceAll("\\</span\\>", " ");
        text = text.replaceAll("\\<table\\>", " ");
        text = text.replaceAll("\\</table\\>", " ");
        text = text.replaceAll("\\<custom-table\\>", " ");
        text = text.replaceAll("\\</custom-table\\>", " ");
        text = text.replaceAll("\\<tbody\\>", " ");
        text = text.replaceAll("\\</tbody\\>", " ");
        text = text.replaceAll("\\<td\\>", " ");
        text = text.replaceAll("\\</td\\>", " ");
        text = text.replaceAll("\\<tr\\>", " ");
        text = text.replaceAll("\\</tr\\>", " ");
        text = text.replaceAll("\\<click\\-question\\>", " ");
        text = text.replaceAll("\\</click\\-question\\>", " ");
        text = text.replaceAll("\\</iframe\\>", " ");
        text = MDfromHTMLUtils.removeTag(text, "<a ");
        text = MDfromHTMLUtils.removeTag(text, "<iframe ");
        text = MDfromHTMLUtils.removeTag(text, "<td ");
        text = MDfromHTMLUtils.removeTag(text, "<tr ");
        text = MDfromHTMLUtils.removeTag(text, "<span ");
        text = MDfromHTMLUtils.removeTag(text, "<table ");
        text = MDfromHTMLUtils.removeTag(text, "<tbody ");
        text = MDfromHTMLUtils.removeTag(text, "<p ");
        text = MDfromHTMLUtils.removeTag(text, "<font ");
        text = MDfromHTMLUtils.removeTag(text, "<gettimeoff ");
        text = MDfromHTMLUtils.removeTag(text, "<deletecontextprivatedata ");
        text = MDfromHTMLUtils.removeTag(text, "<custom-table ");
        text = MDfromHTMLUtils.removeTag(text, "<button ");
        text = MDfromHTMLUtils.removeTag(text, "<setactionstage ");
        text = MDfromHTMLUtils.removeTag(text, "<valuereplace ");
        text = MDfromHTMLUtils.removeTag(text, "<answer ");
        return text;
    }

    public static String cleanURL(String url) {
        int index = url.indexOf("\r");
        while (index >= 0) {
            url = url.substring(0, index);
            index = url.indexOf("\r");
        }
        index = url.indexOf("\n");
        while (index >= 0) {
            url = url.substring(0, index);
            index = url.indexOf("\n");
        }
        index = url.indexOf("\u00a0");
        if (index >= 0) {
            url = url.substring(0, index);
        }
        while (url.endsWith(".") || url.endsWith(",") || url.endsWith("\"") || url.endsWith("!") || url.endsWith("'") || url.endsWith("?") || url.endsWith(":") || url.endsWith("]") || url.endsWith(")") || url.endsWith("`") || url.endsWith("\\") || url.endsWith("/") || url.endsWith("\r") || url.endsWith("\n") || url.endsWith("\t") || url.endsWith("\u00a0") || url.endsWith("\u2028") || url.endsWith("\u2029") || url.endsWith("\u2019") || url.endsWith("\u201a")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String[] cleanWord(String word) {
        String[] result = new String[]{"", "", ""};
        if (word == null) {
            return result;
        }
        if ((word = MDfromHTMLUtils.trimSpaces(word)).length() == 0) {
            result[1] = word;
            return result;
        }
        int index = 0;
        int len = word.length();
        char wordchar = word.charAt(index);
        StringBuffer sb = new StringBuffer();
        while (wordchar < '0' || wordchar > '9' && wordchar < 'a' && wordchar != '@' || wordchar > 'z' && wordchar <= '\u007f' || wordchar == '\u2003' || wordchar == '\u2013' || wordchar == '\u2018' || wordchar == '\u2019' || wordchar == '\u201c' || wordchar == '\u201d' || wordchar == '\u2022' || wordchar == '\u2026' || wordchar == '\u2028' || wordchar == '\u202a' || wordchar == '\u202c' || wordchar == '\u202f') {
            sb.append(wordchar);
            if (++index == len) break;
            wordchar = word.charAt(index);
        }
        result[0] = sb.toString();
        if (index == len) {
            return result;
        }
        word = word.substring(index);
        len = word.length();
        index = len - 1;
        sb.setLength(0);
        wordchar = word.charAt(index);
        while (wordchar < '0' || wordchar > '9' && wordchar < 'a' && wordchar != '@' || wordchar > 'z' && wordchar <= '\u007f' || wordchar == '\u2003' || wordchar == '\u2013' || wordchar == '\u2018' || wordchar == '\u2019' || wordchar == '\u201c' || wordchar == '\u201d' || wordchar == '\u2022' || wordchar == '\u2026' || wordchar == '\u2028' || wordchar == '\u202a' || wordchar == '\u202c' || wordchar == '\u202f') {
            sb.append(wordchar);
            if (--index == 0) break;
            wordchar = word.charAt(index);
        }
        result[2] = sb.reverse().toString();
        result[1] = word = word.substring(0, index + 1);
        return result;
    }

    public static void closeTextFile(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeTextFile(BufferedWriter bw) {
        if (bw != null) {
            try {
                bw.flush();
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String convertMillisecondsToTimeZone(int iMillisecs) {
        StringBuffer sb = new StringBuffer();
        if (iMillisecs < 0) {
            sb.append("-");
            iMillisecs *= -1;
        } else {
            sb.append("+");
        }
        int iHours = iMillisecs / 3600000;
        if (iHours < 10) {
            sb.append("0");
        }
        sb.append(iHours);
        int iMinutes = (iMillisecs -= iHours * 3600000) / 60000;
        if (iMinutes < 10) {
            sb.append("0");
        }
        sb.append(iMinutes);
        return sb.toString();
    }

    public static int convertTimeZoneToMilliseconds(String strTimeZone) {
        int iMillisecs = 0;
        if (strTimeZone == null || strTimeZone.length() != 5) {
            return iMillisecs;
        }
        String strSign = strTimeZone.substring(0, 1);
        String strHours = strTimeZone.substring(1, 3);
        String strMinutes = strTimeZone.substring(3, 5);
        try {
            int iHours = new Integer(strHours);
            int iMinutes = new Integer(strMinutes);
            iMillisecs = iMinutes * 60000;
            iMillisecs += iHours * 3600000;
            if (strSign.startsWith("-")) {
                iMillisecs *= -1;
            }
        }
        catch (NumberFormatException nfe) {
            iMillisecs = 0;
        }
        return iMillisecs;
    }

    public static String exceptionTraceToString(Throwable throwableException) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwableException.printStackTrace(pw);
        String sStackTrace = sw.toString();
        return sStackTrace;
    }

    public static String fromUTF8Bytes(byte[] bytes) {
        return new String(bytes, UTF8_CHARSET);
    }

    public static char[] getKey() {
        String pwKey = System.getenv("MDfromHTML_MaskerKey");
        if (!(pwKey != null && pwKey.trim().length() != 0 || (pwKey = System.getProperty("MDfromHTML_MaskerKey")) != null && pwKey.trim().length() != 0)) {
            return MDfromHTMLConstants.MDfromHTML_DEFAULT_PROPERTY_FILE_KEY;
        }
        return pwKey.toCharArray();
    }

    public static String getMDfromHTMLHomeDirectory() throws Exception {
        File retFile = null;
        String strPath = System.getenv("MDfromHTML_HOME");
        if (strPath == null) {
            strPath = System.getProperty("MDfromHTML_HOME");
        }
        if (strPath == null) {
            strPath = System.getProperty("user.home");
            if (strPath == null) {
                throw new Exception("Can not find Environment variable nor System property for MDfromHTML_HOME nor the user.home System property so can not return the MDfromHTML Home Directory.");
            }
            while (strPath.length() > 2 && strPath.endsWith(File.separator)) {
                strPath = strPath.substring(0, strPath.length() - 1);
            }
            strPath = strPath + File.separator + "MDfromHTML";
        } else {
            while (strPath.length() > 2 && strPath.endsWith(File.separator)) {
                strPath = strPath.substring(0, strPath.length() - 1);
            }
        }
        try {
            retFile = new File(strPath);
            if (!retFile.exists() || retFile.isFile()) {
                strPath = System.getProperty("user.dir");
                if (strPath == null) {
                    throw new Exception("Can not find Environment variable nor System property for MDfromHTML_HOME nor the user.home System property so can not return the MDfromHTML Home Directory.");
                }
                while (strPath.length() > 2 && strPath.endsWith(File.separator)) {
                    strPath = strPath.substring(0, strPath.length() - 1);
                }
                retFile = new File(strPath = strPath + File.separator + "MDfromHTML");
                if (!retFile.exists() || retFile.isFile()) {
                    throw new Exception("Can not find directory " + strPath);
                }
            }
            return retFile.getCanonicalPath();
        }
        catch (Exception fnfe) {
            throw new Exception("Can not find directory " + strPath);
        }
    }

    public static Properties getMDfromHTMLIPCProps() throws Exception {
        Properties ipcProps = MDfromHTMLUtils.loadMDfromHTMLProperties("MDfromHTMLIPC.properties");
        return ipcProps;
    }

    public static Properties getMDfromHTMLServicesProps() throws Exception {
        return MDfromHTMLUtils.loadMDfromHTMLProperties("MDfromHTML.properties");
    }

    public static String getMDfromHTMLWebServicesURI() {
        StringBuffer sb = new StringBuffer();
        sb.append(MDfromHTMLPropertyManager.getProtocol());
        sb.append("://");
        sb.append(MDfromHTMLPropertyManager.getHostName());
        sb.append(":");
        sb.append(MDfromHTMLPropertyManager.getPortNumber());
        sb.append("/");
        sb.append(MDfromHTMLPropertyManager.getServletName());
        sb.append("/");
        sb.append(MDfromHTMLPropertyManager.getVersion());
        sb.append("/");
        return sb.toString();
    }

    public static String getNameFromClass(Class<?> inClass) {
        return inClass.getName().lastIndexOf(".") == -1 ? inClass.getName() : inClass.getName().substring(inClass.getName().lastIndexOf(".") + 1);
    }

    public static synchronized String getUniqueID() {
        byte[] byteID = new byte[20];
        if (MDfromHTMLConstants.SEED_SECURE_RANDOM != null) {
            MDfromHTMLConstants.SEED_SECURE_RANDOM.nextBytes(byteID);
            return MDfromHTMLUtils.hexEncode(byteID);
        }
        Date date = new Date();
        StringBuffer sb = new StringBuffer();
        sb.append("X");
        sb.append(Long.toHexString(date.getTime()));
        sb.append(Long.toHexString(MDfromHTMLConstants.SEED_RANDOM.nextLong()));
        return sb.toString();
    }

    public static byte[] hexDecode(String strHex) throws InvalidParameterException {
        if (strHex == null || strHex.length() == 0) {
            throw new InvalidParameterException("Null or empty string passed.  Must pass string containing pairs of hexadecimal digits.");
        }
        int iLength = strHex.length();
        if (iLength % 2 > 0) {
            throw new InvalidParameterException("An odd number of bytes was passed in the input string.  Must be an even number.");
        }
        byte[] inBytes = strHex.toUpperCase().getBytes(MDfromHTMLConstants.UTF8_CHARSET);
        byte[] baRC = new byte[iLength / 2];
        int iHighOffset = -1;
        int iLowOffset = -1;
        for (int i = 0; i < iLength; i += 2) {
            iHighOffset = "0123456789ABCDEF".indexOf(inBytes[i]);
            if (iHighOffset < 0) {
                throw new InvalidParameterException("Input string contains non-hexadecimal digit at index " + i + ".  Must be 0-9 or A-F");
            }
            iLowOffset = "0123456789ABCDEF".indexOf(inBytes[i + 1]);
            if (iLowOffset < 0) {
                throw new InvalidParameterException("Input string contains non-hexadecimal digit at index " + i + ".  Must be 0-9 or A-F");
            }
            baRC[i / 2] = (byte)(iHighOffset * 16 + iLowOffset);
        }
        return baRC;
    }

    public static String hexEncode(byte[] bArray) {
        StringBuffer sb = new StringBuffer();
        if (bArray == null || bArray.length == 0) {
            return sb.toString();
        }
        char[] cHexPair = new char[2];
        int iArrayLength = bArray.length;
        for (int iByteCount = 0; iByteCount < iArrayLength; ++iByteCount) {
            cHexPair = MDfromHTMLUtils.byteToHexChars(bArray[iByteCount]);
            sb.append(new String(cHexPair));
        }
        return sb.toString();
    }

    public static boolean isEmpty(String strInput) {
        if (strInput == null) {
            return false;
        }
        return strInput.compareTo("") == 0;
    }

    public static boolean isUndefined(BigInteger testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_BigInteger);
    }

    public static boolean isUndefined(Boolean testValue) {
        return testValue == MDfromHTMLConstants.UNDEFINED_Boolean;
    }

    public static boolean isUndefined(byte testValue) {
        return testValue == 126;
    }

    public static boolean isUndefined(Byte testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_Byte);
    }

    public static boolean isUndefined(char testValue) {
        return testValue == '\ufffe';
    }

    public static boolean isUndefined(Character testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_Character);
    }

    public static boolean isUndefined(Class<?> testValue) {
        return testValue == null;
    }

    public static boolean isUndefined(double testValue) {
        return new Double(testValue).equals(MDfromHTMLConstants.UNDEFINED_Double);
    }

    public static boolean isUndefined(Double testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_Double);
    }

    public static boolean isUndefined(float testValue) {
        return new Float(testValue).equals(MDfromHTMLConstants.UNDEFINED_Float);
    }

    public static boolean isUndefined(Float testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_Float);
    }

    public static boolean isUndefined(int iTestValue) {
        return iTestValue == 0x7FFFFFFE;
    }

    public static boolean isUndefined(Integer testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_Integer);
    }

    public static boolean isUndefined(long testValue) {
        return testValue == 0x1FFFFFFFFFFFFEL;
    }

    public static boolean isUndefined(Long testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_Long);
    }

    public static boolean isUndefined(Object testValue) {
        if (testValue == null) {
            return true;
        }
        Class<?> objClass = testValue.getClass();
        if (MDfromHTMLUtils.isUndefined(objClass)) {
            return true;
        }
        if (objClass == Double.class) {
            return MDfromHTMLUtils.isUndefined((Double)testValue);
        }
        if (objClass == Integer.class) {
            return MDfromHTMLUtils.isUndefined((Integer)testValue);
        }
        if (objClass == String.class) {
            return MDfromHTMLUtils.isUndefined((String)testValue);
        }
        if (objClass == Byte.class) {
            return MDfromHTMLUtils.isUndefined((Byte)testValue);
        }
        if (objClass == Character.class) {
            return MDfromHTMLUtils.isUndefined((Character)testValue);
        }
        if (objClass == Float.class) {
            return MDfromHTMLUtils.isUndefined((Float)testValue);
        }
        if (objClass == Long.class) {
            return MDfromHTMLUtils.isUndefined((Long)testValue);
        }
        if (objClass == Short.class) {
            return MDfromHTMLUtils.isUndefined((Short)testValue);
        }
        if (objClass == BigInteger.class) {
            return MDfromHTMLUtils.isUndefined((BigInteger)testValue);
        }
        if (objClass == Date.class) {
            return MDfromHTMLDate.isUndefined((Date)testValue);
        }
        if (objClass == MDfromHTMLDate.class) {
            return MDfromHTMLDate.isUndefined((MDfromHTMLDate)testValue);
        }
        if (objClass == JSONObject.class) {
            try {
                ((JSONObject)testValue).serialize();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUndefined(short testValue) {
        return testValue == 32766;
    }

    public static boolean isUndefined(Short testValue) {
        if (testValue == null) {
            return true;
        }
        return testValue.equals(MDfromHTMLConstants.UNDEFINED_Short);
    }

    public static boolean isUndefined(String testValue) {
        if (testValue == null || testValue.trim().length() == 0) {
            return true;
        }
        if ("null".equals(testValue = testValue.trim())) {
            return true;
        }
        return testValue.equals("?");
    }

    public static boolean isUndefined(URI testValue) {
        if (testValue == null) {
            return true;
        }
        return MDfromHTMLConstants.UNDEFINED_URI.equals(testValue);
    }

    public static boolean isValidURL(String url) {
        boolean result = false;
        if (url.length() < 7) {
            return result;
        }
        String secure = url.substring(4, 5);
        if (secure.equalsIgnoreCase("s")) {
            if (url.length() < 8) {
                return result;
            }
            if (url.length() >= 12 && url.substring(5, 12).equals("://http")) {
                return result;
            }
            result = url.substring(5, 8).equals("://");
        } else {
            if (!secure.equals(":")) {
                return result;
            }
            if (url.length() >= 11 && url.substring(4, 11).equals("://http")) {
                return result;
            }
            result = url.substring(5, 7).equals("//");
        }
        return result;
    }

    public static List<Path> listSourceFiles(Path dir, String ext) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "*.{" + ext + "}");){
            for (Path entry : stream) {
                result.add(entry);
            }
        }
        catch (DirectoryIteratorException ex) {
            throw ex.getCause();
        }
        result.sort(null);
        return result;
    }

    public static ArrayList<Object> listStringToArrayList(String strList) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (strList == null || strList.length() == 0) {
            return list;
        }
        String strRecord = strList;
        while (strRecord.startsWith("{")) {
            strRecord = strRecord.substring(1);
        }
        while (strRecord.endsWith("}")) {
            strRecord = strRecord.substring(0, strRecord.length() - 1);
        }
        Object[] objList = MDfromHTMLUtils.parseFields(strRecord);
        for (int i = 0; i < objList.length; ++i) {
            list.add(objList[i]);
        }
        return list;
    }

    public static JSONArray loadJSONArray(String jsonFQFileName) throws Exception {
        JSONArray retObj = new JSONArray();
        BufferedReader br = null;
        try {
            br = MDfromHTMLUtils.openTextFile(jsonFQFileName);
            if (br != null) {
                retObj = JSONArray.parse((Reader)br);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Can not parse \"" + jsonFQFileName + "\"", ioe);
        }
        catch (Exception e) {
            throw new IOException("Can not load file \"" + jsonFQFileName + "\"", e);
        }
        finally {
            MDfromHTMLUtils.closeTextFile(br);
        }
        return retObj;
    }

    public static JSONArtifact loadJSONArtifact(String jsonFQFileName) throws Exception {
        JSONArtifact retObj = null;
        BufferedReader br = null;
        try {
            br = MDfromHTMLUtils.openTextFile(jsonFQFileName);
            if (br != null) {
                retObj = JSON.parse((Reader)br);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Can not parse \"" + jsonFQFileName + "\"", ioe);
        }
        catch (Exception e) {
            throw new IOException("Can not load file \"" + jsonFQFileName + "\"", e);
        }
        finally {
            MDfromHTMLUtils.closeTextFile(br);
        }
        if (retObj == null) {
            retObj = new JSONObject();
        }
        return retObj;
    }

    public static JSONObject loadJSONFile(String jsonFQFileName) throws Exception {
        JSONObject retObj = new JSONObject();
        BufferedReader br = null;
        try {
            br = MDfromHTMLUtils.openTextFile(jsonFQFileName);
            if (br != null) {
                retObj = JSONObject.parse((Reader)br);
            }
        }
        catch (IOException ioe) {
            throw new IOException("Can not parse \"" + jsonFQFileName + "\"", ioe);
        }
        catch (Exception e) {
            throw new IOException("Can not load file \"" + jsonFQFileName + "\"", e);
        }
        finally {
            MDfromHTMLUtils.closeTextFile(br);
        }
        return retObj;
    }

    public static Properties loadMDfromHTMLProperties(String strPropFileName) throws Exception {
        String strPath;
        InputStream is;
        Properties propFile;
        block35: {
            propFile = new Properties();
            is = null;
            strPath = MDfromHTMLUtils.getMDfromHTMLHomeDirectory();
            String subDirectory = MDfromHTMLConstants.MDfromHTML_DIR_PROPERTIES;
            try {
                if (!strPath.endsWith(File.separator)) {
                    strPath = strPath + File.separator;
                }
                strPath = strPath + subDirectory;
                strPath = strPath + strPropFileName;
                is = new FileInputStream(new File(strPath));
            }
            catch (Exception fnfe) {
                strPath = strPropFileName;
                try {
                    is = new FileInputStream(new File(strPath));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (is != null) break block35;
                try {
                    strPath = MDfromHTMLConstants.MDfromHTML_DIR_PROPERTIES + strPath;
                    is = new FileInputStream(new File(strPath));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        try {
            if (is == null) {
                is = MDfromHTMLUtils.class.getResourceAsStream(File.separator + strPropFileName);
            }
            if (is == null) {
                is = MDfromHTMLUtils.class.getResourceAsStream(strPropFileName);
            }
            if (is == null) {
                throw new Exception("Can not load properties path: " + strPropFileName);
            }
            propFile.load(is);
            if (propFile.size() == 0) {
                throw new Exception(strPropFileName + " is empty.");
            }
        }
        catch (IOException e) {
            throw new IOException("Can not load " + strPath, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (propFile.size() == 0) {
            FileInputStream fis = null;
            try {
                propFile = new Properties();
                fis = new FileInputStream(strPropFileName);
                propFile.load(fis);
            }
            catch (IOException ioe) {
                throw new Exception("Can not open file \"" + strPropFileName + "\" nor " + strPath, ioe);
            }
            catch (Exception fnfe) {
                throw new Exception("Can not open file \"" + strPropFileName + "\" nor " + strPath, fnfe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (propFile.size() == 0) {
            throw new Exception("Can not locate property file \"" + strPropFileName + "\" nor " + strPath + "\n Ensure " + "MDfromHTML_HOME" + " has been set properly.");
        }
        for (Object key : propFile.keySet()) {
            String prop = propFile.getProperty(key.toString());
            if (prop == null) continue;
            propFile.setProperty(key.toString(), prop.toString().trim());
        }
        return propFile;
    }

    public static List<String> loadTextFile(String fqFilename) throws Exception {
        return MDfromHTMLUtils.loadTextFile(fqFilename, StandardCharsets.UTF_8);
    }

    public static List<String> loadTextFile(String fqFilename, Charset charSet) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader br = MDfromHTMLUtils.openTextFile(fqFilename, charSet);
        String line = br.readLine();
        while (line != null) {
            result.add(line);
            line = br.readLine();
        }
        MDfromHTMLUtils.closeTextFile(br);
        return result;
    }

    public static BufferedReader openTextFile(String fqFilename) throws Exception {
        return MDfromHTMLUtils.openTextFile(fqFilename, StandardCharsets.UTF_8);
    }

    public static BufferedReader openTextFile(String fqFilename, Charset charSet) throws Exception {
        BufferedReader input = null;
        File inputFile = new File(fqFilename);
        if (!inputFile.exists()) {
            throw new Exception(inputFile.getCanonicalPath() + " does not exist.");
        }
        if (!inputFile.isFile()) {
            throw new IOException("Input is not a file: " + inputFile.getCanonicalPath() + File.separator + inputFile.getName());
        }
        if (!inputFile.canRead()) {
            throw new IOException("Can not read file " + inputFile.getCanonicalPath() + File.separator + inputFile.getName());
        }
        input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), charSet));
        return input;
    }

    public static BufferedWriter openTextWriterFile(String fqFilename) throws Exception {
        BufferedWriter output = null;
        File outputFile = new File(fqFilename);
        if (outputFile.exists() && !outputFile.isFile()) {
            throw new IOException("Output is not a file: " + outputFile.getCanonicalPath() + File.separator + outputFile.getName());
        }
        if (outputFile.exists()) {
            outputFile.delete();
        }
        outputFile.createNewFile();
        if (!outputFile.canWrite()) {
            throw new IOException("Can not write file " + outputFile.getCanonicalPath() + File.separator + outputFile.getName());
        }
        output = new BufferedWriter(new FileWriter(outputFile, true));
        return output;
    }

    public static BufferedWriter openAppendTextFile(String fqFilename) throws Exception {
        BufferedWriter br = null;
        File outputFile = new File(fqFilename);
        br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, true), StandardCharsets.UTF_8));
        return br;
    }

    public static BufferedWriter openWriteTextFile(String fqFilename) throws Exception {
        BufferedWriter br = null;
        File outputFile = new File(fqFilename);
        br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));
        return br;
    }

    public static BufferedWriter openWriteTextFile(String fqFilename, Charset charSet) throws Exception {
        BufferedWriter br = null;
        File outputFile = new File(fqFilename);
        br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), charSet));
        return br;
    }

    public static String padLeft(int iIn, int iWidth, char cPad) {
        String strTemp = String.valueOf(iIn);
        return MDfromHTMLUtils.padLeft(strTemp, iWidth, cPad);
    }

    public static String padLeft(String strInput, int iMax, char cPadChar) {
        if (strInput == null) {
            char[] padChars = new char[iMax];
            Arrays.fill(padChars, cPadChar);
            return new String(padChars);
        }
        int iLength = strInput.length();
        if (iLength < iMax) {
            char[] padChars = new char[iMax - iLength];
            Arrays.fill(padChars, cPadChar);
            return new String(padChars) + strInput;
        }
        return strInput;
    }

    public static String padLeftZero(int iValue, int iMax) {
        return MDfromHTMLUtils.padLeft(String.valueOf(iValue), iMax, '0');
    }

    public static String padLeftZero(String strInput, int iMax) {
        return MDfromHTMLUtils.padLeft(strInput, iMax, '0');
    }

    public static String padRight(int iIn, int iWidth, char cPad) {
        String strTemp = String.valueOf(iIn);
        return MDfromHTMLUtils.padRight(strTemp, iWidth, cPad);
    }

    public static String padRight(String strInput, int iMax, char cPadChar) {
        if (strInput == null) {
            char[] padChars = new char[iMax];
            Arrays.fill(padChars, cPadChar);
            return new String(padChars);
        }
        int iLength = strInput.length();
        if (iLength < iMax) {
            char[] padChars = new char[iMax - iLength];
            Arrays.fill(padChars, cPadChar);
            return strInput + new String(padChars);
        }
        return strInput;
    }

    public static String padRightZero(int iValue, int iMax) {
        return MDfromHTMLUtils.padRight(String.valueOf(iValue), iMax, '0');
    }

    public static String padRightZero(String strInput, int iMax) {
        return MDfromHTMLUtils.padRight(strInput, iMax, '0');
    }

    public static String[] parseCSV(String strRecord, boolean removeEmptyStrings) {
        if (strRecord == null || strRecord.length() == 0) {
            return new String[0];
        }
        if (removeEmptyStrings) {
            strRecord = strRecord.replaceAll("\"\"", "");
        }
        ArrayList<String> retArray = new ArrayList<String>();
        byte[] recbytes = strRecord.getBytes();
        int iLength = recbytes.length;
        boolean bInQuoted = false;
        boolean bInField = false;
        int bLastByte = 0;
        boolean bNeedDelim = false;
        int iFieldStart = 0;
        int iFieldCount = 0;
        for (int i = 0; i < iLength; ++i) {
            switch (recbytes[i]) {
                case 9: {
                    String strField;
                    if (!bInField) {
                        ++iFieldStart;
                        bNeedDelim = false;
                        break;
                    }
                    if (!bInQuoted) {
                        strField = new String(recbytes, iFieldStart, iFieldCount);
                        retArray.add(strField);
                        bInQuoted = false;
                        bInField = false;
                        bNeedDelim = false;
                        iFieldCount = 0;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                case 44: {
                    String strField;
                    if (!bInField) {
                        if (bLastByte == 44) {
                            retArray.add("");
                            bInQuoted = false;
                            bInField = false;
                            bNeedDelim = false;
                            iFieldCount = 0;
                            break;
                        }
                        ++iFieldStart;
                        bNeedDelim = false;
                        break;
                    }
                    if (!bInQuoted) {
                        strField = new String(recbytes, iFieldStart, iFieldCount);
                        retArray.add(strField);
                        bInQuoted = false;
                        bInField = false;
                        bNeedDelim = false;
                        iFieldCount = 0;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                case 34: {
                    String strField;
                    if (bLastByte == 47) break;
                    if (!bInField) {
                        iFieldStart = i + 1;
                        iFieldCount = 0;
                        bInField = true;
                        bInQuoted = true;
                        break;
                    }
                    if (bInQuoted) {
                        strField = new String(recbytes, iFieldStart, iFieldCount);
                        retArray.add(strField);
                        bInQuoted = false;
                        bInField = false;
                        bNeedDelim = true;
                        iFieldCount = 0;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                default: {
                    if (!bInField) {
                        if (bNeedDelim) break;
                        iFieldStart = i;
                        iFieldCount = 1;
                        bInField = true;
                        bInQuoted = false;
                        break;
                    }
                    ++iFieldCount;
                }
            }
            bLastByte = recbytes[i];
        }
        if (bInField || bLastByte == 44) {
            String strField = new String(recbytes, iFieldStart, iFieldCount);
            retArray.add(strField);
        }
        return retArray.toArray(new String[0]);
    }

    public static Object[] parseFields(String strRecord) {
        if (strRecord == null || strRecord.length() == 0) {
            return new Object[0];
        }
        ArrayList<Object> retArray = new ArrayList<Object>();
        byte[] recbytes = strRecord.getBytes();
        int iLength = recbytes.length;
        boolean bInList = false;
        boolean bInQuoted = false;
        boolean bInField = false;
        int bLastByte = 0;
        boolean bNeedDelim = false;
        int iFieldStart = 0;
        int iFieldCount = 0;
        for (int i = 0; i < iLength; ++i) {
            switch (recbytes[i]) {
                case 9: 
                case 32: 
                case 124: {
                    String strField;
                    if (!bInField) {
                        ++iFieldStart;
                        bNeedDelim = false;
                        break;
                    }
                    if (!bInQuoted && !bInList) {
                        strField = new String(recbytes, iFieldStart, iFieldCount);
                        retArray.add(MDfromHTMLUtils.processField(strField));
                        bInQuoted = false;
                        bInField = false;
                        bNeedDelim = false;
                        iFieldCount = 0;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                case 44: {
                    String strField;
                    if (!bInField) {
                        if (bLastByte == 44) {
                            retArray.add(MDfromHTMLUtils.processField(null));
                            bInQuoted = false;
                            bInField = false;
                            bNeedDelim = false;
                            iFieldCount = 0;
                            break;
                        }
                        ++iFieldStart;
                        bNeedDelim = false;
                        break;
                    }
                    if (!bInQuoted && !bInList) {
                        strField = new String(recbytes, iFieldStart, iFieldCount);
                        retArray.add(MDfromHTMLUtils.processField(strField));
                        bInQuoted = false;
                        bInField = false;
                        bNeedDelim = false;
                        iFieldCount = 0;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                case 34: {
                    String strField;
                    if (!bInField) {
                        iFieldStart = i + 1;
                        iFieldCount = 0;
                        bInField = true;
                        bInQuoted = true;
                        break;
                    }
                    if (bInQuoted) {
                        strField = new String(recbytes, iFieldStart, iFieldCount);
                        retArray.add(strField);
                        bInQuoted = false;
                        bInField = false;
                        bNeedDelim = true;
                        iFieldCount = 0;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                case 123: {
                    if (!bInField) {
                        iFieldStart = i + 1;
                        iFieldCount = 0;
                        bInField = true;
                        bInList = true;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                case 125: {
                    String strField;
                    if (bInList) {
                        strField = new String(recbytes, iFieldStart, iFieldCount);
                        strField = "{" + strField + "}";
                        retArray.add(MDfromHTMLUtils.processField(strField));
                        bInList = false;
                        bInField = false;
                        bNeedDelim = true;
                        iFieldCount = 0;
                        break;
                    }
                    ++iFieldCount;
                    break;
                }
                default: {
                    if (!bInField) {
                        if (bNeedDelim) break;
                        iFieldStart = i;
                        iFieldCount = 1;
                        bInField = true;
                        bInQuoted = false;
                        break;
                    }
                    ++iFieldCount;
                }
            }
            bLastByte = recbytes[i];
        }
        if (bInField || bLastByte == 44) {
            String strField = new String(recbytes, iFieldStart, iFieldCount);
            retArray.add(MDfromHTMLUtils.processField(strField));
        }
        return retArray.toArray();
    }

    public static Object processField(String strField) {
        if (strField == null || strField.length() == 0) {
            return null;
        }
        Object objField = null;
        try {
            if (strField.indexOf(46) == -1) {
                Integer iField = new Integer(strField);
                objField = iField;
            } else {
                Double dField = new Double(strField);
                objField = dField;
            }
        }
        catch (Exception e) {
            if (strField == null || strField.length() == 0) {
                strField = "?";
            }
            objField = strField;
        }
        return objField;
    }

    public static String prompt(String strPrompt) {
        return MDfromHTMLUtils.prompt(strPrompt, true);
    }

    public static String prompt(String strPrompt, boolean bTrim) {
        String strReply = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            if (strPrompt != null && strPrompt.length() != 0) {
                System.out.println(strPrompt);
            }
            strReply = in.readLine();
            if (bTrim && strReply != null) {
                strReply = strReply.trim();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return strReply;
    }

    public static String readLine(BufferedReader br) throws IOException {
        HashSet<Integer> terminators = new HashSet<Integer>();
        terminators.add(10);
        return MDfromHTMLUtils.readLine(br, terminators);
    }

    public static String readLine(BufferedReader br, HashSet<Integer> terminators) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = br.read();
        while (c != -1) {
            if (terminators.contains(c)) {
                return sb.toString();
            }
            sb.append((char)c);
            c = br.read();
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static String removeTag(String text, String tagPrefix) {
        int index = text.indexOf(tagPrefix);
        if (index == -1) {
            return text;
        }
        int indexEnd = 0;
        String newText = "";
        String start = "";
        String end = "";
        while (index >= 0) {
            start = text.substring(0, index);
            newText = newText + start;
            indexEnd = (text = text.substring(index + tagPrefix.length())).indexOf(">");
            if (indexEnd >= 0) {
                end = text.substring(indexEnd + 1);
                text = text.substring(indexEnd + 1);
            }
            if ((index = text.indexOf(tagPrefix)) >= 0) {
                newText = newText + " " + end.substring(0, index);
                text = end.substring(index);
                index = 0;
                continue;
            }
            newText = newText + " " + end;
        }
        return newText;
    }

    public static JSONObject saveJSONFile(String jsonFileName, JSONObject jsonData) throws Exception {
        if (jsonData == null) {
            throw new InvalidObjectException("jsonData is null");
        }
        if (jsonFileName == null || jsonFileName.trim().length() == 0) {
            throw new InvalidTargetObjectTypeException("Output filename is null or empty.");
        }
        BufferedWriter br = null;
        try {
            File outputFile = new File(jsonFileName);
            br = new BufferedWriter(new FileWriter(outputFile));
            br.write(jsonData.serialize(true));
        }
        catch (IOException e) {
            throw new IOException("Can not write file \"" + jsonFileName + "\"", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return jsonData;
    }

    public static void saveTextFile(String textFileName, String content) throws Exception {
        if (content == null) {
            throw new InvalidObjectException("content is null");
        }
        if (textFileName == null || textFileName.trim().length() == 0) {
            throw new InvalidTargetObjectTypeException("Output filename is null or empty.");
        }
        BufferedWriter br = null;
        try {
            File outputFile = new File(textFileName);
            br = new BufferedWriter(new FileWriter(outputFile));
            br.write(content);
        }
        catch (IOException e) {
            throw new IOException("Can not write file \"" + textFileName + "\"", e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String shortenString(String input, int maxLen) {
        if (maxLen < 2) {
            return input;
        }
        if (input == null) {
            return input;
        }
        if (input.length() < maxLen) {
            return input;
        }
        return input.substring(0, maxLen) + "...";
    }

    public static byte[] toUTF8Bytes(String string) {
        return string.getBytes(UTF8_CHARSET);
    }

    public static String trimSpaces(String word) {
        while (word.startsWith(" ")) {
            word = word.substring(1);
        }
        while (word.endsWith(" ")) {
            word = word.substring(0, word.length() - 1);
        }
        return word;
    }

    public static Date undefinedForNull(Date date) {
        if (date == null) {
            return MDfromHTMLConstants.UNDEFINED_Date;
        }
        return date;
    }

    public static Double undefinedForNull(Double DValue) {
        if (DValue == null) {
            return MDfromHTMLConstants.UNDEFINED_Double;
        }
        return DValue;
    }

    public static Integer undefinedForNull(Integer intInput) {
        if (intInput == null) {
            return MDfromHTMLConstants.UNDEFINED_Integer;
        }
        return intInput;
    }

    public static String undefinedForNull(String strValue) {
        if (strValue == null) {
            return "?";
        }
        if (strValue.trim().length() == 0) {
            return "?";
        }
        return strValue;
    }

    public static String unescapeMarkdown(String mdLine) {
        String result = mdLine.replaceAll("\\\\-", "\\-");
        result = result.replaceAll("\\\\.", "\\.");
        return result;
    }
}

