/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.imsweb.seerapi.client.ErrorResponse;
import java.io.IOException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.map.ObjectMapper;

@Provider
public class ErrorResponseFilter
implements ClientResponseFilter {
    private static ObjectMapper _MAPPER = new ObjectMapper();

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatus() != Response.Status.OK.getStatusCode() && responseContext.hasEntity()) {
            BadRequestException webAppException;
            ErrorResponse error = (ErrorResponse)_MAPPER.readValue(responseContext.getEntityStream(), ErrorResponse.class);
            String message = error.getMessage();
            Response.Status status = Response.Status.fromStatusCode((int)responseContext.getStatus());
            switch (status) {
                case BAD_REQUEST: {
                    webAppException = new BadRequestException(message);
                    break;
                }
                case UNAUTHORIZED: {
                    webAppException = new NotAuthorizedException((Object)message, new Object[0]);
                    break;
                }
                case FORBIDDEN: {
                    webAppException = new ForbiddenException(message);
                    break;
                }
                case NOT_FOUND: {
                    webAppException = new NotFoundException(message);
                    break;
                }
                case METHOD_NOT_ALLOWED: {
                    webAppException = new NotAllowedException(message, new String[0]);
                    break;
                }
                case NOT_ACCEPTABLE: {
                    webAppException = new NotAcceptableException(message);
                    break;
                }
                case UNSUPPORTED_MEDIA_TYPE: {
                    webAppException = new NotSupportedException(message);
                    break;
                }
                case INTERNAL_SERVER_ERROR: {
                    webAppException = new InternalServerErrorException(message);
                    break;
                }
                case SERVICE_UNAVAILABLE: {
                    webAppException = new ServiceUnavailableException(message);
                    break;
                }
                default: {
                    webAppException = new WebApplicationException(message);
                }
            }
            throw webAppException;
        }
    }
}

