/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.imsweb.seerapi.client.ErrorResponseFilter;
import com.imsweb.seerapi.client.disease.Disease;
import com.imsweb.seerapi.client.disease.DiseaseChangelogResults;
import com.imsweb.seerapi.client.disease.DiseaseSearch;
import com.imsweb.seerapi.client.disease.DiseaseSearchResults;
import com.imsweb.seerapi.client.disease.DiseaseVersion;
import com.imsweb.seerapi.client.disease.PrimarySite;
import com.imsweb.seerapi.client.disease.SamePrimaries;
import com.imsweb.seerapi.client.disease.SiteCategory;
import com.imsweb.seerapi.client.glossary.Glossary;
import com.imsweb.seerapi.client.glossary.GlossaryChangelogResults;
import com.imsweb.seerapi.client.glossary.GlossarySearch;
import com.imsweb.seerapi.client.glossary.GlossarySearchResults;
import com.imsweb.seerapi.client.glossary.GlossaryVersion;
import com.imsweb.seerapi.client.naaccr.NaaccrField;
import com.imsweb.seerapi.client.naaccr.NaaccrFieldName;
import com.imsweb.seerapi.client.naaccr.NaaccrVersion;
import com.imsweb.seerapi.client.rx.Rx;
import com.imsweb.seerapi.client.rx.RxChangelogResults;
import com.imsweb.seerapi.client.rx.RxSearch;
import com.imsweb.seerapi.client.rx.RxSearchResults;
import com.imsweb.seerapi.client.rx.RxVersion;
import com.imsweb.seerapi.client.shared.Version;
import com.imsweb.seerapi.client.siterecode.SiteRecode;
import com.imsweb.seerapi.client.staging.SchemaLookup;
import com.imsweb.seerapi.client.staging.StagingAlgorithm;
import com.imsweb.seerapi.client.staging.StagingData;
import com.imsweb.seerapi.client.staging.StagingSchema;
import com.imsweb.seerapi.client.staging.StagingSchemaInfo;
import com.imsweb.seerapi.client.staging.StagingTable;
import com.imsweb.seerapi.client.staging.StagingVersion;
import com.imsweb.seerapi.client.surgery.SurgeryTable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.glassfish.jersey.message.GZipEncoder;

public final class SeerApi {
    private static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final JacksonJsonProvider _JACKSON_PROVIDER = new JacksonJsonProvider();
    private Client _client;
    private String _baseUrl;
    private String _apiKey;

    private SeerApi(String baseUrl, String apiKey) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this._baseUrl = baseUrl;
        this._apiKey = apiKey;
        this._client = (Client)((Client)((Client)ClientBuilder.newClient().register((Object)_JACKSON_PROVIDER)).register(GZipEncoder.class)).register(ErrorResponseFilter.class);
    }

    protected static SeerApi connect(String baseUrl, String apiKey) {
        return new SeerApi(baseUrl, apiKey);
    }

    private WebTarget createTarget(String path) {
        if (this._apiKey == null || this._apiKey.isEmpty()) {
            throw new IllegalStateException("This operation requires a credential but none is given to the SeerApi constructor");
        }
        return this._client.target(this._baseUrl).path(path);
    }

    private Invocation.Builder getBuilder(WebTarget target) {
        return target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-SEERAPI-Key", (Object)this._apiKey).acceptEncoding(new String[]{"gzip"});
    }

    public String siteRecodeVersion() {
        WebTarget target = this.createTarget("/recode/version");
        return ((Version)this.getBuilder(target).get(Version.class)).getVersion();
    }

    public SiteRecode siteRecode(String site, String histology) {
        WebTarget target = this.createTarget("/recode/sitegroup").queryParam("site", new Object[]{site}).queryParam("hist", new Object[]{histology});
        return (SiteRecode)this.getBuilder(target).get(SiteRecode.class);
    }

    public List<NaaccrVersion> naaccrVersions() {
        WebTarget target = this.createTarget("/naaccr/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<NaaccrVersion>>(){});
    }

    public List<NaaccrFieldName> naaccrFieldNames(String version) {
        WebTarget target = this.createTarget("/naaccr/{version}").resolveTemplate("version", (Object)version);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<NaaccrFieldName>>(){});
    }

    public NaaccrField naaccrField(String version, Integer item) {
        WebTarget target = this.createTarget("/naaccr/{version}/item/{item}").resolveTemplate("version", (Object)version).resolveTemplate("item", (Object)item);
        return (NaaccrField)this.getBuilder(target).get(NaaccrField.class);
    }

    public List<DiseaseVersion> diseaseVersions() {
        WebTarget target = this.createTarget("/disease/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<DiseaseVersion>>(){});
    }

    public DiseaseChangelogResults diseaseChangelogs(String version, String fromDate, String toDate, Integer count) {
        WebTarget target = this.createTarget("/disease/{version}/changelog").resolveTemplate("version", (Object)version).queryParam("from", new Object[]{fromDate}).queryParam("to", new Object[]{toDate}).queryParam("count", new Object[]{count});
        return (DiseaseChangelogResults)this.getBuilder(target).get(DiseaseChangelogResults.class);
    }

    public DiseaseSearchResults diseaseSearch(String version, DiseaseSearch search) {
        WebTarget target = this.createTarget("/disease/{version}").resolveTemplate("version", (Object)version);
        target = target.queryParam("q", new Object[]{search.getQuery()}).queryParam("type", new Object[]{search.getType()}).queryParam("site_category", new Object[]{search.getSiteCategory()}).queryParam("mode", new Object[]{search.getMode()}).queryParam("status", new Object[]{search.getStatus()}).queryParam("assigned_to", new Object[]{search.getAssignedTo()}).queryParam("modified_from", new Object[]{search.getModifiedFrom()}).queryParam("modified_to", new Object[]{search.getModifiedTo()}).queryParam("published_from", new Object[]{search.getPublishedFrom()}).queryParam("published_to", new Object[]{search.getPublishedTo()}).queryParam("been_published", new Object[]{search.getBeenPublished()}).queryParam("hidden", new Object[]{search.getHidden()}).queryParam("count", new Object[]{search.getCount()}).queryParam("offset", new Object[]{search.getOffset()}).queryParam("order", new Object[]{search.getOrderBy()}).queryParam("output_type", new Object[]{search.getOutputType()});
        return (DiseaseSearchResults)this.getBuilder(target).get(DiseaseSearchResults.class);
    }

    public Disease diseaseById(String version, String id) {
        return this.diseaseById(version, id, false);
    }

    public Disease diseaseById(String version, String id, boolean includeGlossary) {
        WebTarget target = this.createTarget("/disease/{version}/id/{id}").resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id).queryParam("glossary", new Object[]{includeGlossary});
        return (Disease)this.getBuilder(target).get(Disease.class);
    }

    public List<PrimarySite> diseasePrimarySites() {
        WebTarget target = this.createTarget("/disease/primary_site");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<PrimarySite>>(){});
    }

    public List<PrimarySite> diseasePrimarySiteCode(String primarySite) {
        WebTarget target = this.createTarget("/disease/primary_site/{code}").resolveTemplate("code", (Object)primarySite);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<PrimarySite>>(){});
    }

    public List<SiteCategory> diseaseSiteCategories() {
        WebTarget target = this.createTarget("/disease/site_categories");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<SiteCategory>>(){});
    }

    public SamePrimaries diseaseSamePrimaries(String version, String morphology1, String morphology2, String year) {
        WebTarget target = this.createTarget("/disease/{version}/same_primary").resolveTemplate("version", (Object)version).queryParam("d1", new Object[]{morphology1}).queryParam("d2", new Object[]{morphology2}).queryParam("year", new Object[]{year});
        return (SamePrimaries)this.getBuilder(target).get(SamePrimaries.class);
    }

    public Disease diseaseReportability(Disease disease) {
        WebTarget target = this.createTarget("/disease/reportability");
        return (Disease)this.getBuilder(target).post(Entity.json((Object)disease), Disease.class);
    }

    public List<GlossaryVersion> glossaryVersions() {
        WebTarget target = this.createTarget("/glossary/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<GlossaryVersion>>(){});
    }

    public Glossary glossaryById(String version, String id) {
        WebTarget target = this.createTarget("/glossary/{version}/id/{id}").resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (Glossary)this.getBuilder(target).get(Glossary.class);
    }

    public GlossarySearchResults glossarySearch(String version, GlossarySearch search) {
        WebTarget target = this.createTarget("/glossary/{version}").resolveTemplate("version", (Object)version);
        target = target.queryParam("q", new Object[]{search.getQuery()}).queryParam("mode", new Object[]{search.getMode()}).queryParam("status", new Object[]{search.getStatus()}).queryParam("assigned_to", new Object[]{search.getAssignedTo()}).queryParam("modified_from", new Object[]{search.getModifiedFrom()}).queryParam("modified_to", new Object[]{search.getModifiedTo()}).queryParam("published_from", new Object[]{search.getPublishedFrom()}).queryParam("published_to", new Object[]{search.getPublishedTo()}).queryParam("been_published", new Object[]{search.getBeenPublished()}).queryParam("hidden", new Object[]{search.getHidden()}).queryParam("count", new Object[]{search.getCount()}).queryParam("offset", new Object[]{search.getOffset()}).queryParam("order", new Object[]{search.getOrderBy()}).queryParam("output_type", new Object[]{search.getOutputType()});
        if (search.getCategory() != null) {
            target = target.queryParam("category", search.getCategory().toArray());
        }
        return (GlossarySearchResults)this.getBuilder(target).get(GlossarySearchResults.class);
    }

    public GlossaryChangelogResults glossaryChangelogs(String version, String fromDate, String toDate, Integer count) {
        WebTarget target = this.createTarget("/glossary/{version}/changelog").resolveTemplate("version", (Object)version).queryParam("from", new Object[]{fromDate}).queryParam("to", new Object[]{toDate}).queryParam("count", new Object[]{count});
        return (GlossaryChangelogResults)this.getBuilder(target).get(GlossaryChangelogResults.class);
    }

    public List<Version> siteSpecificSurgeryVersions() {
        WebTarget target = this.createTarget("/surgery/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<Version>>(){});
    }

    public List<String> siteSpecificSurgeryTables(String version) {
        WebTarget target = this.createTarget("/surgery/{version}/tables").resolveTemplate("version", (Object)version);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<String>>(){});
    }

    public SurgeryTable siteSpecificSurgeryTable(String version, String title, String site, String histology) {
        WebTarget target = this.createTarget("/surgery/{version}/table").resolveTemplate("version", (Object)version).queryParam("title", new Object[]{title}).queryParam("site", new Object[]{site}).queryParam("hist", new Object[]{histology});
        return (SurgeryTable)this.getBuilder(target).get(SurgeryTable.class);
    }

    public List<RxVersion> rxVersions() {
        WebTarget target = this.createTarget("/rx/versions");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<RxVersion>>(){});
    }

    public Rx rxById(String version, String id) {
        return this.rxById(version, id, false);
    }

    public Rx rxById(String version, String id, boolean includeGlossary) {
        WebTarget target = this.createTarget("/rx/{version}/id/{id}").resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id).queryParam("glossary", new Object[]{includeGlossary});
        return (Rx)this.getBuilder(target).get(Rx.class);
    }

    public RxSearchResults rxSearch(String version, RxSearch search) {
        WebTarget target = this.createTarget("/rx/{version}").resolveTemplate("version", (Object)version);
        target = target.queryParam("q", new Object[]{search.getQuery()}).queryParam("type", new Object[]{search.getType()}).queryParam("do_not_code", new Object[]{search.getDoNotCode()}).queryParam("category", new Object[]{search.getCategory()}).queryParam("mode", new Object[]{search.getMode()}).queryParam("status", new Object[]{search.getStatus()}).queryParam("assigned_to", new Object[]{search.getAssignedTo()}).queryParam("modified_from", new Object[]{search.getModifiedFrom()}).queryParam("modified_to", new Object[]{search.getModifiedTo()}).queryParam("published_from", new Object[]{search.getPublishedFrom()}).queryParam("published_to", new Object[]{search.getPublishedTo()}).queryParam("been_published", new Object[]{search.getBeenPublished()}).queryParam("hidden", new Object[]{search.getHidden()}).queryParam("count", new Object[]{search.getCount()}).queryParam("offset", new Object[]{search.getOffset()}).queryParam("order", new Object[]{search.getOrderBy()}).queryParam("output_type", new Object[]{search.getOutputType()});
        return (RxSearchResults)this.getBuilder(target).get(RxSearchResults.class);
    }

    public RxChangelogResults rxChangelogs(String version, String fromDate, String toDate, Integer count) {
        WebTarget target = this.createTarget("/rx/{version}/changelog").resolveTemplate("version", (Object)version).queryParam("from", new Object[]{fromDate}).queryParam("to", new Object[]{toDate}).queryParam("count", new Object[]{count});
        return (RxChangelogResults)this.getBuilder(target).get(RxChangelogResults.class);
    }

    public List<StagingAlgorithm> stagingAlgorithms() {
        WebTarget target = this.createTarget("/staging/algorithms");
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingAlgorithm>>(){});
    }

    public List<StagingVersion> stagingAlgorithmVersions(String algorithm) {
        WebTarget target = this.createTarget("/staging/{algorithm}/versions").resolveTemplate("algorithm", (Object)algorithm);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingVersion>>(){});
    }

    public List<StagingSchemaInfo> stagingSchemas(String algorithm, String version, String query) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/schemas").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).queryParam("q", new Object[]{query});
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingSchemaInfo>>(){});
    }

    public List<StagingSchemaInfo> stagingSchemaLookup(String algorithm, String version, SchemaLookup data) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/schemas/lookup").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version);
        return (List)this.getBuilder(target).post(Entity.json(data.getInputs()), (GenericType)new GenericType<List<StagingSchemaInfo>>(){});
    }

    public StagingSchema stagingSchemaById(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/schema/{id}").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (StagingSchema)this.getBuilder(target).get(StagingSchema.class);
    }

    public List<StagingTable> stagingSchemaInvolvedTables(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/schema/{id}/tables").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingTable>>(){});
    }

    public List<StagingTable> stagingTables(String algorithm, String version, String query) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/tables").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).queryParam("q", new Object[]{query});
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingTable>>(){});
    }

    public StagingTable stagingTableById(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/table/{id}").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (StagingTable)this.getBuilder(target).get(StagingTable.class);
    }

    public List<StagingSchema> stagingTableInvolvedSchemas(String algorithm, String version, String id) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/table/{id}/schemas").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version).resolveTemplate("id", (Object)id);
        return (List)this.getBuilder(target).get((GenericType)new GenericType<List<StagingSchema>>(){});
    }

    public StagingData stagingStage(String algorithm, String version, StagingData data) {
        WebTarget target = this.createTarget("/staging/{algorithm}/{version}/stage").resolveTemplate("algorithm", (Object)algorithm).resolveTemplate("version", (Object)version);
        return (StagingData)this.getBuilder(target).post(Entity.json(data.getInput()), StagingData.class);
    }

    static {
        _DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, false);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setDateFormat(_DATE_FORMAT);
        mapper.setVisibility(JsonMethod.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        _JACKSON_PROVIDER.setMapper(mapper);
    }
}

