/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.imsweb.seerapi.client.SeerApi;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class SeerApiBuilder {
    private static final String _SEERAPI_URL = "https://api.seer.cancer.gov/rest";
    private static final String _ENV_URL = "SEER_API_URL";
    private static final String _ENV_API_KEY = "SEER_API_KEY";
    private String _url;
    private String _apiKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() {
        Properties props = new Properties();
        File config = new File(System.getProperty("user.home"), ".seerapi");
        if (config.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(config);
                props.load(in);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return props;
    }

    public SeerApiBuilder() {
        Properties props = this.getProperties();
        this._url = props.getProperty("url");
        if (this._url == null) {
            this._url = System.getenv(_ENV_URL);
        }
        if (this._url == null) {
            this._url = _SEERAPI_URL;
        }
        this._apiKey = props.getProperty("apikey");
        if (this._apiKey == null) {
            this._apiKey = System.getenv(_ENV_API_KEY);
        }
    }

    public SeerApiBuilder url(String url) {
        this._url = url;
        return this;
    }

    public SeerApiBuilder apiKey(String apiKey) {
        this._apiKey = apiKey;
        return this;
    }

    public SeerApi connect() {
        return SeerApi.connect(this._url, this._apiKey);
    }
}

