/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.imsweb.seerapi.client.BadRequestException;
import com.imsweb.seerapi.client.ErrorResponse;
import com.imsweb.seerapi.client.NotAuthorizedException;
import com.imsweb.seerapi.client.SeerApiException;
import java.io.IOException;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;
import retrofit.client.Response;

class SeerApiErrorHandler
implements ErrorHandler {
    SeerApiErrorHandler() {
    }

    public Throwable handleError(RetrofitError cause) {
        Response r = cause.getResponse();
        if (r != null) {
            ErrorResponse error = null;
            try {
                if (r.getBody() != null) {
                    error = (ErrorResponse)new ObjectMapper().readValue(r.getBody().in(), ErrorResponse.class);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            String message = error == null ? cause.getMessage() : error.getMessage();
            switch (r.getStatus()) {
                case 401: {
                    return new NotAuthorizedException(message, (Throwable)cause);
                }
                case 400: {
                    return new BadRequestException(message, (Throwable)cause);
                }
            }
            return new SeerApiException(message, (Throwable)cause);
        }
        return cause;
    }
}

