/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.imsweb.seerapi.client.ErrorInterceptor;
import com.imsweb.seerapi.client.disease.DiseaseService;
import com.imsweb.seerapi.client.glossary.GlossaryService;
import com.imsweb.seerapi.client.hcpcs.HcpcsService;
import com.imsweb.seerapi.client.mph.MphService;
import com.imsweb.seerapi.client.naaccr.NaaccrService;
import com.imsweb.seerapi.client.ndc.NdcService;
import com.imsweb.seerapi.client.rx.RxService;
import com.imsweb.seerapi.client.siterecode.SiteRecodeService;
import com.imsweb.seerapi.client.staging.StagingService;
import com.imsweb.seerapi.client.surgery.SurgeryService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class SeerApi {
    private DiseaseService _diseaseService;
    private GlossaryService _glossaryService;
    private MphService _mphService;
    private NaaccrService _naaccrService;
    private NdcService _ndcService;
    private RxService _rxService;
    private SiteRecodeService _siteRecodeService;
    private StagingService _stagingService;
    private SurgeryService _surgeryService;
    private HcpcsService _hcpcsService;

    private SeerApi(String baseUrl, String apiKey) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request original = chain.request();
            Request request = original.newBuilder().header("Accept", "application/json").header("X-SEERAPI-Key", apiKey).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }).addInterceptor((Interceptor)new ErrorInterceptor()).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)SeerApi.getMapper())).client(client).build();
        this._diseaseService = (DiseaseService)retrofit.create(DiseaseService.class);
        this._glossaryService = (GlossaryService)retrofit.create(GlossaryService.class);
        this._mphService = (MphService)retrofit.create(MphService.class);
        this._naaccrService = (NaaccrService)retrofit.create(NaaccrService.class);
        this._ndcService = (NdcService)retrofit.create(NdcService.class);
        this._rxService = (RxService)retrofit.create(RxService.class);
        this._siteRecodeService = (SiteRecodeService)retrofit.create(SiteRecodeService.class);
        this._stagingService = (StagingService)retrofit.create(StagingService.class);
        this._surgeryService = (SurgeryService)retrofit.create(SurgeryService.class);
        this._hcpcsService = (HcpcsService)retrofit.create(HcpcsService.class);
    }

    static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        mapper.setDateFormat((DateFormat)dateFormat);
        return mapper;
    }

    public DiseaseService disease() {
        return this._diseaseService;
    }

    public GlossaryService glossary() {
        return this._glossaryService;
    }

    public MphService mph() {
        return this._mphService;
    }

    public NaaccrService naaccr() {
        return this._naaccrService;
    }

    public NdcService ndc() {
        return this._ndcService;
    }

    public RxService rx() {
        return this._rxService;
    }

    public SiteRecodeService siteRecode() {
        return this._siteRecodeService;
    }

    public StagingService staging() {
        return this._stagingService;
    }

    public SurgeryService surgery() {
        return this._surgeryService;
    }

    public HcpcsService hcpcs() {
        return this._hcpcsService;
    }

    public static class Builder {
        private static final String _SEERAPI_URL = "https://api.seer.cancer.gov/rest/";
        private static final String _ENV_URL = "SEER_API_URL";
        private static final String _ENV_API_KEY = "SEER_API_KEY";
        private String _url;
        private String _apiKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getProperties() {
            Properties props = new Properties();
            File config = new File(System.getProperty("user.home"), ".seerapi");
            if (config.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(config);
                    props.load(in);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            return props;
        }

        public Builder() {
            Properties props = this.getProperties();
            this._url = props.getProperty("url");
            if (this._url == null) {
                this._url = System.getenv(_ENV_URL);
            }
            if (this._url == null) {
                this._url = _SEERAPI_URL;
            }
            this._apiKey = props.getProperty("apikey");
            if (this._apiKey == null) {
                this._apiKey = System.getenv(_ENV_API_KEY);
            }
        }

        public Builder url(String url) {
            this._url = url;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this._apiKey = apiKey;
            return this;
        }

        public SeerApi connect() {
            return new SeerApi(this._url, this._apiKey);
        }
    }
}

