/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.imsweb.seerapi.client.BadRequestException;
import com.imsweb.seerapi.client.ErrorResponse;
import com.imsweb.seerapi.client.NotAuthorizedException;
import com.imsweb.seerapi.client.NotFoundException;
import com.imsweb.seerapi.client.SeerApiException;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class ErrorInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (response.code() != 200) {
            ErrorResponse error = null;
            ResponseBody body = response.body();
            if (body != null) {
                try {
                    error = (ErrorResponse)new ObjectMapper().readValue(body.byteStream(), ErrorResponse.class);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String message = error == null ? "Error code " + response.code() : error.getMessage();
            switch (response.code()) {
                case 401: {
                    throw new NotAuthorizedException(message);
                }
                case 400: {
                    throw new BadRequestException(message);
                }
                case 404: {
                    throw new NotFoundException(message);
                }
            }
            throw new SeerApiException(message);
        }
        return response;
    }
}

