/*
 * Decompiled with CFR 0.152.
 */
package com.indico;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class Async {
    public static <T> CompletableFuture<Response<T>> executeSync(ApolloCall<T> apolloCall) {
        final CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.whenComplete((tResponse, throwable) -> {
            if (completableFuture.isCancelled()) {
                completableFuture.cancel(true);
            }
        });
        apolloCall.enqueue(new ApolloCall.Callback<T>(){

            public void onResponse(@NotNull Response<T> response) {
                completableFuture.complete(response);
            }

            public void onFailure(@NotNull ApolloException e) {
                completableFuture.completeExceptionally((Throwable)e);
            }
        });
        return completableFuture;
    }
}

