/*
 * Decompiled with CFR 0.152.
 */
package com.indico;

import com.apollographql.apollo.ApolloClient;
import com.indico.IndicoConfig;
import com.indico.TokenAuthenticator;
import com.indico.jobs.JobQuery;
import com.indico.mutation.DocumentExtraction;
import com.indico.mutation.ModelGroupLoad;
import com.indico.mutation.ModelGroupPredict;
import com.indico.mutation.WorkflowSubmission;
import com.indico.query.ModelGroupQuery;
import com.indico.query.TrainingModelWithProgressQuery;
import com.indico.query.WorkflowQuery;
import com.indico.request.GraphQLRequest;
import com.indico.storage.PurgeBlob;
import com.indico.storage.RetrieveBlob;
import com.indico.storage.UploadFile;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;

public class IndicoClient
implements AutoCloseable {
    public final IndicoConfig config;
    public final OkHttpClient okHttpClient;
    public final ApolloClient apolloClient;
    private final ThreadPoolExecutor dispatcher;

    public IndicoClient(IndicoConfig config) {
        this.config = config;
        String serverURL = config.protocol + "://" + config.host;
        this.okHttpClient = new OkHttpClient.Builder().authenticator((Authenticator)new TokenAuthenticator(serverURL, config.apiToken)).readTimeout((long)config.connectionReadTimeout, TimeUnit.SECONDS).writeTimeout((long)config.connectionWriteTimeout, TimeUnit.SECONDS).build();
        this.dispatcher = this.dispatcher(config.maxConnections);
        this.apolloClient = ApolloClient.builder().serverUrl(serverURL + "/graph/api/graphql").okHttpClient(this.okHttpClient).dispatcher((Executor)this.dispatcher).build();
    }

    public GraphQLRequest graphQLRequest() {
        return new GraphQLRequest(this);
    }

    public ModelGroupQuery modelGroupQuery() {
        return new ModelGroupQuery(this.apolloClient);
    }

    public TrainingModelWithProgressQuery trainingModelWithProgressQuery() {
        return new TrainingModelWithProgressQuery(this);
    }

    public ModelGroupPredict modelGroupPredict() {
        return new ModelGroupPredict(this.apolloClient);
    }

    public ModelGroupLoad modelGroupLoad() {
        return new ModelGroupLoad(this.apolloClient);
    }

    public DocumentExtraction documentExtraction() {
        return new DocumentExtraction(this);
    }

    public WorkflowQuery workflowQuery() {
        return new WorkflowQuery();
    }

    public WorkflowSubmission workflowSubmission() {
        return new WorkflowSubmission();
    }

    public JobQuery jobQuery() {
        return new JobQuery(this.apolloClient);
    }

    public RetrieveBlob retrieveBlob() {
        return new RetrieveBlob(this);
    }

    public PurgeBlob purgeBlob() {
        return new PurgeBlob();
    }

    public UploadFile uploadFile() {
        return new UploadFile(this);
    }

    @Override
    public void close() throws Exception {
        this.dispatcher.shutdown();
        this.okHttpClient.dispatcher().executorService().shutdown();
    }

    private ThreadPoolExecutor dispatcher(int maxConnections) {
        return new ThreadPoolExecutor(0, maxConnections, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> new Thread(runnable, "Apollo Dispatcher"));
    }
}

