/*
 * Decompiled with CFR 0.152.
 */
package com.indico.mutation;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.api.Response;
import com.indico.Async;
import com.indico.Mutation;
import com.indico.PredictModelGraphQLMutation;
import com.indico.entity.ModelGroup;
import com.indico.jobs.Job;
import com.indico.jobs.JobOptions;
import java.util.List;

public class ModelGroupPredict
implements Mutation<Job> {
    private int modelId;
    private List<String> data;
    private JobOptions jobOptions;
    private final ApolloClient apolloClient;

    public ModelGroupPredict(ApolloClient apolloClient) {
        this.apolloClient = apolloClient;
    }

    public ModelGroupPredict modelGroup(ModelGroup modelGroup) {
        this.modelId = modelGroup.selectedModel.id;
        return this;
    }

    public ModelGroupPredict modelId(int modelId) {
        this.modelId = modelId;
        return this;
    }

    public ModelGroupPredict data(List<String> data) {
        this.data = data;
        return this;
    }

    public ModelGroupPredict jobOptions(JobOptions jobOptions) {
        this.jobOptions = jobOptions;
        return this;
    }

    @Override
    public Job execute() {
        ApolloMutationCall apolloCall = this.apolloClient.mutate((com.apollographql.apollo.api.Mutation)PredictModelGraphQLMutation.builder().modelId(this.modelId).data(this.data).build());
        Response response = Async.executeSync(apolloCall).join();
        String jobId = ((PredictModelGraphQLMutation.Data)response.data()).modelPredict().jobId();
        return new Job(this.apolloClient, jobId);
    }
}

