/*
 * Decompiled with CFR 0.152.
 */
package com.indico;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.internal.QueryDocumentMinifier;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import com.indico.type.SubmissionStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GetSubmissionGraphQLQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "92c8756c0b2bc622578cbb6e0f7cace6b7635da0d2c2eca910e88abd6e60c29a";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query GetSubmissionGraphQL($submissionId: Int!) {\n  submission(id: $submissionId) {\n    __typename\n    id\n    datasetId\n    workflowId\n    status\n    inputFile\n    inputFilename\n    resultFile\n    retrieved\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "GetSubmissionGraphQL";
        }
    };
    private final Variables variables;

    public GetSubmissionGraphQLQuery(int submissionId) {
        this.variables = new Variables(submissionId);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    public static class Submission {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"id", (String)"id", null, (boolean)true, Collections.emptyList()), ResponseField.forInt((String)"datasetId", (String)"datasetId", null, (boolean)true, Collections.emptyList()), ResponseField.forInt((String)"workflowId", (String)"workflowId", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"status", (String)"status", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"inputFile", (String)"inputFile", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"inputFilename", (String)"inputFilename", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"resultFile", (String)"resultFile", null, (boolean)true, Collections.emptyList()), ResponseField.forBoolean((String)"retrieved", (String)"retrieved", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Integer id;
        @Nullable
        final Integer datasetId;
        @Nullable
        final Integer workflowId;
        @Nullable
        final SubmissionStatus status;
        @Nullable
        final String inputFile;
        @Nullable
        final String inputFilename;
        @Nullable
        final String resultFile;
        @Nullable
        final Boolean retrieved;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Submission(@NotNull String __typename, @Nullable Integer id, @Nullable Integer datasetId, @Nullable Integer workflowId, @Nullable SubmissionStatus status, @Nullable String inputFile, @Nullable String inputFilename, @Nullable String resultFile, @Nullable Boolean retrieved) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = id;
            this.datasetId = datasetId;
            this.workflowId = workflowId;
            this.status = status;
            this.inputFile = inputFile;
            this.inputFilename = inputFilename;
            this.resultFile = resultFile;
            this.retrieved = retrieved;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Integer id() {
            return this.id;
        }

        @Nullable
        public Integer datasetId() {
            return this.datasetId;
        }

        @Nullable
        public Integer workflowId() {
            return this.workflowId;
        }

        @Nullable
        public SubmissionStatus status() {
            return this.status;
        }

        @Nullable
        public String inputFile() {
            return this.inputFile;
        }

        @Nullable
        public String inputFilename() {
            return this.inputFilename;
        }

        @Nullable
        public String resultFile() {
            return this.resultFile;
        }

        @Nullable
        public Boolean retrieved() {
            return this.retrieved;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeInt($responseFields[1], id);
                    writer.writeInt($responseFields[2], datasetId);
                    writer.writeInt($responseFields[3], workflowId);
                    writer.writeString($responseFields[4], status != null ? status.rawValue() : null);
                    writer.writeString($responseFields[5], inputFile);
                    writer.writeString($responseFields[6], inputFilename);
                    writer.writeString($responseFields[7], resultFile);
                    writer.writeBoolean($responseFields[8], retrieved);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Submission{__typename=" + this.__typename + ", id=" + this.id + ", datasetId=" + this.datasetId + ", workflowId=" + this.workflowId + ", status=" + (Object)((Object)this.status) + ", inputFile=" + this.inputFile + ", inputFilename=" + this.inputFilename + ", resultFile=" + this.resultFile + ", retrieved=" + this.retrieved + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Submission) {
                Submission that = (Submission)o;
                return this.__typename.equals(that.__typename) && (this.id == null ? that.id == null : this.id.equals(that.id)) && (this.datasetId == null ? that.datasetId == null : this.datasetId.equals(that.datasetId)) && (this.workflowId == null ? that.workflowId == null : this.workflowId.equals(that.workflowId)) && (this.status == null ? that.status == null : this.status.equals((Object)that.status)) && (this.inputFile == null ? that.inputFile == null : this.inputFile.equals(that.inputFile)) && (this.inputFilename == null ? that.inputFilename == null : this.inputFilename.equals(that.inputFilename)) && (this.resultFile == null ? that.resultFile == null : this.resultFile.equals(that.resultFile)) && (this.retrieved == null ? that.retrieved == null : this.retrieved.equals(that.retrieved));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id == null ? 0 : this.id.hashCode();
                h *= 1000003;
                h ^= this.datasetId == null ? 0 : this.datasetId.hashCode();
                h *= 1000003;
                h ^= this.workflowId == null ? 0 : this.workflowId.hashCode();
                h *= 1000003;
                h ^= this.status == null ? 0 : this.status.hashCode();
                h *= 1000003;
                h ^= this.inputFile == null ? 0 : this.inputFile.hashCode();
                h *= 1000003;
                h ^= this.inputFilename == null ? 0 : this.inputFilename.hashCode();
                h *= 1000003;
                h ^= this.resultFile == null ? 0 : this.resultFile.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.retrieved == null ? 0 : this.retrieved.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Submission> {
            public Submission map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Integer id = reader.readInt($responseFields[1]);
                Integer datasetId = reader.readInt($responseFields[2]);
                Integer workflowId = reader.readInt($responseFields[3]);
                String statusStr = reader.readString($responseFields[4]);
                SubmissionStatus status = statusStr != null ? SubmissionStatus.safeValueOf(statusStr) : null;
                String inputFile = reader.readString($responseFields[5]);
                String inputFilename = reader.readString($responseFields[6]);
                String resultFile = reader.readString($responseFields[7]);
                Boolean retrieved = reader.readBoolean($responseFields[8]);
                return new Submission(__typename, id, datasetId, workflowId, status, inputFile, inputFilename, resultFile, retrieved);
            }
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"submission", (String)"submission", (Map)new UnmodifiableMapBuilder(1).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"submissionId").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final Submission submission;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable Submission submission) {
            this.submission = submission;
        }

        @Nullable
        public Submission submission() {
            return this.submission;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], submission != null ? submission.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{submission=" + this.submission + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.submission == null ? that.submission == null : this.submission.equals(that.submission);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.submission == null ? 0 : this.submission.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Submission.Mapper submissionFieldMapper = new Submission.Mapper();

            public Data map(ResponseReader reader) {
                Submission submission = (Submission)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Submission>(){

                    public Submission read(ResponseReader reader) {
                        return submissionFieldMapper.map(reader);
                    }
                });
                return new Data(submission);
            }
        }
    }

    public static final class Variables
    extends Operation.Variables {
        private final int submissionId;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(int submissionId) {
            this.submissionId = submissionId;
            this.valueMap.put("submissionId", submissionId);
        }

        public int submissionId() {
            return this.submissionId;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeInt("submissionId", Integer.valueOf(submissionId));
                }
            };
        }
    }

    public static final class Builder {
        private int submissionId;

        Builder() {
        }

        public Builder submissionId(int submissionId) {
            this.submissionId = submissionId;
            return this;
        }

        public GetSubmissionGraphQLQuery build() {
            return new GetSubmissionGraphQLQuery(this.submissionId);
        }
    }
}

