/*
 * Decompiled with CFR 0.152.
 */
package com.indico;

import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.json.JSONObject;

class TokenAuthenticator
implements Authenticator {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    final String refreshToken;
    final String serverURL;

    public TokenAuthenticator(String serverURL, String refreshToken) {
        this.serverURL = serverURL;
        this.refreshToken = refreshToken;
    }

    public Request authenticate(Route route, Response response) throws IOException {
        if (response.code() == 401) {
            Call refreshCall = this.refreshAccessToken(this.serverURL, this.refreshToken);
            Response refreshResponse = refreshCall.execute();
            if (refreshResponse != null && refreshResponse.code() == 200) {
                String responseBody = refreshResponse.body().string();
                JSONObject json = new JSONObject(responseBody);
                String authToken = (String)json.get("auth_token");
                return response.request().newBuilder().header("Authorization", "Bearer " + authToken).build();
            }
            return null;
        }
        return null;
    }

    private Call refreshAccessToken(String serverURL, String apiToken) throws IOException {
        OkHttpClient okHttpClient = new OkHttpClient();
        String refreshTokenURL = serverURL + "/auth/users/refresh_token";
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)"{}");
        Request request = new Request.Builder().addHeader("Authorization", "Bearer " + apiToken).url(refreshTokenURL).post(requestBody).build();
        return okHttpClient.newCall(request);
    }
}

