/*
 * Decompiled with CFR 0.152.
 */
package com.indico.jobs;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.indico.Async;
import com.indico.JobResultGraphQLQuery;
import com.indico.JobStatusGraphQLQuery;
import com.indico.type.JobStatus;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Job {
    public final String id;
    private final ApolloClient apolloClient;

    public Job(ApolloClient apolloClient, String id) {
        this.apolloClient = apolloClient;
        this.id = id;
    }

    public JobStatus status() {
        ApolloQueryCall apolloCall = this.apolloClient.query((Query)JobStatusGraphQLQuery.builder().id(this.id).build());
        Response response = Async.executeSync(apolloCall).join();
        JobStatusGraphQLQuery.Data data = (JobStatusGraphQLQuery.Data)response.data();
        JobStatus status = data.job().status();
        return status;
    }

    public String resultAsString() {
        String result = this.fetchResult();
        return result;
    }

    public JSONObject result() {
        String result = this.fetchResult();
        return new JSONObject(result);
    }

    public JSONArray results() {
        String result = this.fetchResult();
        return new JSONArray(result);
    }

    private String fetchResult() {
        ApolloQueryCall apolloCall = this.apolloClient.query((Query)JobResultGraphQLQuery.builder().id(this.id).build());
        Response response = Async.executeSync(apolloCall).join();
        JobResultGraphQLQuery.Data data = (JobResultGraphQLQuery.Data)response.data();
        JobResultGraphQLQuery.Job job = data.job();
        JobStatus status = job.status();
        if (status != JobStatus.SUCCESS) {
            throw new RuntimeException("Job finished with status : " + status.rawValue());
        }
        Object result = job.result();
        if (null == result) {
            throw new RuntimeException("Job has finished with no results");
        }
        String out = result.toString();
        return out;
    }

    public List<String> errors() {
        return new ArrayList<String>();
    }
}

