/*
 * Decompiled with CFR 0.152.
 */
package com.indico.mutation;

import com.apollographql.apollo.ApolloMutationCall;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Response;
import com.indico.Async;
import com.indico.DocumentExtractionGraphQLMutation;
import com.indico.IndicoClient;
import com.indico.Mutation;
import com.indico.jobs.Job;
import com.indico.storage.UploadFile;
import com.indico.type.FileInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class DocumentExtraction
implements Mutation<List<Job>> {
    private List<String> files;
    private JSONObject jsonConfig;
    private final IndicoClient indicoClient;

    public DocumentExtraction(IndicoClient indicoClient) {
        this.indicoClient = indicoClient;
    }

    public DocumentExtraction files(List<String> files) {
        this.files = files;
        this.jsonConfig = new JSONObject();
        this.jsonConfig.put("preset_config", (Object)"simple");
        return this;
    }

    public DocumentExtraction jsonConfig(JSONObject jsonConfig) {
        this.jsonConfig = jsonConfig;
        return this;
    }

    @Override
    public List<Job> execute() {
        ArrayList<FileInput> files = new ArrayList<FileInput>();
        try {
            JSONArray fileMetadata = this.upload(this.files);
            for (Object f : fileMetadata) {
                JSONObject uploadMeta = (JSONObject)f;
                JSONObject meta = new JSONObject();
                meta.put("name", (Object)uploadMeta.getString("name"));
                meta.put("path", (Object)uploadMeta.getString("path"));
                meta.put("upload_type", (Object)uploadMeta.getString("upload_type"));
                FileInput input = FileInput.builder().filename(((JSONObject)f).getString("name")).filemeta(meta).build();
                files.add(input);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e.fillInStackTrace());
        }
        ApolloMutationCall apolloCall = this.indicoClient.apolloClient.mutate((com.apollographql.apollo.api.Mutation)DocumentExtractionGraphQLMutation.builder().files(files).jsonConfig(this.jsonConfig).build());
        Response response = Async.executeSync(apolloCall).join();
        if (response.hasErrors()) {
            StringBuilder errors = new StringBuilder();
            for (Error err : response.errors()) {
                errors.append(err.toString() + "\n");
            }
            String msg = errors.toString();
            throw new RuntimeException("Failed to extract documents due to following error: \n" + msg);
        }
        List<String> jobIds = ((DocumentExtractionGraphQLMutation.Data)response.data()).documentExtraction().jobIds();
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (String id : jobIds) {
            Job job = new Job(this.indicoClient.apolloClient, id);
            jobs.add(job);
        }
        return jobs;
    }

    private JSONArray upload(List<String> filePaths) throws IOException {
        UploadFile uploadRequest = new UploadFile(this.indicoClient);
        return uploadRequest.filePaths(filePaths).call();
    }
}

