/*
 * Decompiled with CFR 0.152.
 */
package com.indico.mutation;

import com.indico.IndicoClient;
import com.indico.Mutation;
import com.indico.entity.Submission;
import com.indico.jobs.Job;
import com.indico.mutation.GenerateSubmissionResult;
import com.indico.query.GetSubmission;
import com.indico.type.SubmissionStatus;

public class SubmissionResult
implements Mutation<Job> {
    private final IndicoClient client;
    private int submissionId;
    private SubmissionStatus checkStatus;

    public SubmissionResult(IndicoClient client) {
        this.client = client;
    }

    public SubmissionResult submission(int submissionId) {
        this.submissionId = submissionId;
        return this;
    }

    public SubmissionResult submission(Submission submission) {
        this.submissionId = submission.id;
        return this;
    }

    public SubmissionResult checkStatus(SubmissionStatus checkStatus) {
        this.checkStatus = checkStatus;
        return this;
    }

    @Override
    public Job execute() {
        GetSubmission getSubmission = new GetSubmission(this.client).submissionId(this.submissionId);
        Submission submission = getSubmission.query();
        while (!this.statusCheck(submission.status)) {
            submission = getSubmission.query();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc.getMessage(), exc.fillInStackTrace());
            }
        }
        if (!this.statusCheck(submission.status)) {
            throw new RuntimeException("Request timed out");
        }
        if (submission.status.equals((Object)SubmissionStatus.$UNKNOWN)) {
            throw new RuntimeException("Submission " + this.submissionId + " does not meet status requirements");
        }
        GenerateSubmissionResult generateSubmissionResult = new GenerateSubmissionResult(this.client).submission(submission);
        Job job = generateSubmissionResult.execute();
        return job;
    }

    private boolean statusCheck(SubmissionStatus status) {
        if (this.checkStatus != null) {
            return status.equals((Object)this.checkStatus);
        }
        return !status.equals((Object)SubmissionStatus.PROCESSING);
    }
}

