/*
 * Decompiled with CFR 0.152.
 */
package com.indico.query;

import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.api.Response;
import com.indico.Async;
import com.indico.IndicoClient;
import com.indico.ListSubmissionsGraphQLQuery;
import com.indico.Query;
import com.indico.entity.Submission;
import com.indico.type.SubmissionFilter;
import java.util.ArrayList;
import java.util.List;

public class ListSubmissions
implements Query<List<Submission>> {
    private final IndicoClient client;
    private List<Integer> submissionIds;
    private List<Integer> workflowIds;
    private SubmissionFilter filters;
    private int limit = 1000;

    public ListSubmissions(IndicoClient client) {
        this.client = client;
    }

    public ListSubmissions submissionIds(List<Integer> ids) {
        this.submissionIds = ids;
        return this;
    }

    public ListSubmissions workflowIds(List<Integer> ids) {
        this.workflowIds = ids;
        return this;
    }

    public ListSubmissions filters(SubmissionFilter filters) {
        this.filters = filters;
        return this;
    }

    public ListSubmissions limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public List<Submission> query() {
        ApolloQueryCall apolloCall = this.client.apolloClient.query((com.apollographql.apollo.api.Query)ListSubmissionsGraphQLQuery.builder().submissionIds(this.submissionIds).workflowIds(this.workflowIds).filters(this.filters).limit(this.limit).build());
        Response response = Async.executeSync(apolloCall).join();
        List<ListSubmissionsGraphQLQuery.Submission> submissionList = ((ListSubmissionsGraphQLQuery.Data)response.data()).submissions().submissions();
        ArrayList<Submission> submissions = new ArrayList<Submission>();
        submissionList.forEach(submission -> submissions.add(new Submission.Builder().id(submission.id()).datasetId(submission.datasetId()).workflowId(submission.workflowId()).status(submission.status()).inputFile(submission.inputFile()).inputFilename(submission.inputFilename()).resultFile(submission.resultFile()).build()));
        return submissions;
    }

    @Override
    public List<Submission> refresh(List<Submission> obj) {
        return obj;
    }
}

