/*
 * Decompiled with CFR 0.152.
 */
package com.indico.query;

import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.api.Response;
import com.indico.Async;
import com.indico.IndicoClient;
import com.indico.ListWorkflowsGraphQLQuery;
import com.indico.Query;
import com.indico.entity.Workflow;
import java.util.ArrayList;
import java.util.List;

public class ListWorkflows
implements Query<List<Workflow>> {
    private List<Integer> datasetIds;
    private List<Integer> workflowIds;
    private final IndicoClient client;

    public ListWorkflows(IndicoClient client) {
        this.client = client;
    }

    public ListWorkflows datasetIds(List<Integer> ids) {
        this.datasetIds = ids;
        return this;
    }

    public ListWorkflows workflowIds(List<Integer> ids) {
        this.workflowIds = ids;
        return this;
    }

    @Override
    public List<Workflow> query() {
        ApolloQueryCall apolloCall = this.client.apolloClient.query((com.apollographql.apollo.api.Query)ListWorkflowsGraphQLQuery.builder().datasetIds(this.datasetIds).workflowIds(this.workflowIds).build());
        Response response = Async.executeSync(apolloCall).join();
        List<ListWorkflowsGraphQLQuery.Workflow> wf = ((ListWorkflowsGraphQLQuery.Data)response.data()).workflows().workflows();
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        wf.forEach(workflow -> workflows.add(new Workflow.Builder().id(workflow.id()).name(workflow.name()).reviewEnabled(workflow.reviewEnabled()).build()));
        return workflows;
    }

    @Override
    public List<Workflow> refresh(List<Workflow> obj) {
        return obj;
    }
}

