/*
 * Decompiled with CFR 0.152.
 */
package com.indico.query;

import com.apollographql.apollo.ApolloQueryCall;
import com.apollographql.apollo.api.Response;
import com.indico.Async;
import com.indico.IndicoClient;
import com.indico.ModelGroupProgressGraphQLQuery;
import com.indico.Query;
import com.indico.entity.Model;
import com.indico.entity.TrainingProgress;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TrainingModelWithProgressQuery
implements Query<Model> {
    private int id;
    private String name;
    private final IndicoClient client;

    public TrainingModelWithProgressQuery(IndicoClient client) {
        this.client = client;
    }

    public TrainingModelWithProgressQuery id(int id) {
        this.id = id;
        return this;
    }

    public TrainingModelWithProgressQuery name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Model query() {
        ApolloQueryCall apolloCall = this.client.apolloClient.query((com.apollographql.apollo.api.Query)ModelGroupProgressGraphQLQuery.builder().id(this.id).build());
        Response response = Async.executeSync(apolloCall).join();
        List<ModelGroupProgressGraphQLQuery.ModelGroup> modelGroups = ((ModelGroupProgressGraphQLQuery.Data)response.data()).modelGroups().modelGroups();
        if (modelGroups.size() != 1) {
            throw new RuntimeException("Cannot find Model Group");
        }
        List<ModelGroupProgressGraphQLQuery.Model> models = modelGroups.get(0).models();
        ModelGroupProgressGraphQLQuery.Model model = Collections.max(models, Comparator.comparingInt(m -> m.id()));
        TrainingProgress progress = new TrainingProgress(model.trainingProgress().percentComplete());
        return new Model.Builder().id(model.id()).status(model.status()).trainingProgress(progress).build();
    }

    @Override
    public Model refresh(Model obj) {
        return obj;
    }
}

