/*
 * Decompiled with CFR 0.152.
 */
package com.indico.storage;

import com.indico.IndicoClient;
import com.indico.storage.Blob;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import okhttp3.Request;
import okhttp3.Response;

public class RetrieveBlob {
    private String url;
    private IndicoClient client;

    public RetrieveBlob(IndicoClient client) {
        this.client = client;
    }

    public String gzipDecompress(InputStream compressed) throws IOException {
        String uncompressed;
        try (GZIPInputStream gis = new GZIPInputStream(compressed);
             InputStreamReader reader = new InputStreamReader(gis);
             StringWriter writer = new StringWriter();){
            char[] buffer = new char[10240];
            int length = 0;
            while ((length = reader.read(buffer)) > 0) {
                ((Writer)writer).write(buffer, 0, length);
            }
            uncompressed = ((Object)writer).toString();
        }
        return uncompressed;
    }

    public RetrieveBlob url(String url) {
        url = url.replaceAll("\"", "");
        String path = url.split("://")[1];
        this.url = this.client.config.getAppBaseUrl() + "/" + path;
        return this;
    }

    private Response retrieveBlob() throws IOException {
        Response response = this.client.okHttpClient.newCall(new Request.Builder().url(this.url).get().build()).execute();
        if (response.isSuccessful()) {
            return response;
        }
        throw new IOException("Failed to retrieve blob at url " + this.url);
    }

    private InputStream getInputStream() throws IOException {
        Response response = this.retrieveBlob();
        InputStream data = response.body().byteStream();
        if (this.url.contains(".gz")) {
            return new GZIPInputStream(data);
        }
        return data;
    }

    public Blob execute() throws IOException {
        return new Blob(this.getInputStream());
    }
}

