/*
 * Decompiled with CFR 0.152.
 */
package com.indico.storage;

import com.indico.IndicoClient;
import com.indico.RestRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;

public class UploadFile
implements RestRequest<JSONArray> {
    private IndicoClient client;
    private List<File> files = new ArrayList<File>();

    public UploadFile(IndicoClient client) {
        this.client = client;
    }

    public UploadFile filePaths(List<String> filePaths) {
        for (String path : filePaths) {
            File file = new File(path);
            if (file.exists()) {
                this.files.add(file);
                continue;
            }
            throw new RuntimeException("File " + path + " does not exist");
        }
        return this;
    }

    @Override
    public JSONArray call() throws IOException {
        String uploadUrl = this.client.config.getAppBaseUrl() + "/storage/files/store";
        MultipartBody.Builder multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (File file : this.files) {
            multipartBody.addFormDataPart(file.getName(), "file", RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        }
        MultipartBody requestBody = multipartBody.build();
        Request request = new Request.Builder().url(uploadUrl).post((RequestBody)requestBody).build();
        Response result = this.client.okHttpClient.newCall(request).execute();
        String body = result.body().string();
        JSONArray fileMeta = new JSONArray(body);
        return fileMeta;
    }
}

