/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.util.string.DelimiterStringBuilder;
import com.intersult.util.string.StringReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassReader<Type>
extends ByteArrayInputStream {
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private int[] cpoolIndex;
    private Object[] cpool;
    private Map<String, MethodInfo<Type>> methods = new LinkedHashMap<String, MethodInfo<Type>>();
    private Class<Type> type;

    private ClassReader(Class<Type> type, byte[] bytes) {
        super(bytes);
        int i;
        this.type = type;
        if (this.readInt() != -889275714) {
            throw new IllegalArgumentException("Not a class file");
        }
        this.readShort();
        this.readShort();
        this.readCpool();
        this.readShort();
        this.readShort();
        this.readShort();
        int count = this.readShort();
        for (i = 0; i < count; ++i) {
            this.readShort();
        }
        count = this.readShort();
        for (i = 0; i < count; ++i) {
            this.readShort();
            this.readShort();
            this.readShort();
            this.skipAttributes();
        }
        count = this.readShort();
        for (i = 0; i < count; ++i) {
            this.readMethod();
        }
    }

    private void readMethod() {
        MethodInfo<Type> methodInfo = new MethodInfo<Type>();
        methodInfo.setOwner(this.type);
        methodInfo.setModifiers(this.readShort());
        int m = this.readShort();
        String name = this.resolveUtf8(m);
        int d = this.readShort();
        String descriptor = this.resolveUtf8(d);
        methodInfo.setName(name);
        ClassReader.readMethodDescriptor(methodInfo, descriptor);
        this.readAttributes(methodInfo);
        this.methods.put(name + descriptor, methodInfo);
    }

    public Class<Type> getType() {
        return this.type;
    }

    public Map<String, MethodInfo<Type>> getMethods() {
        return this.methods;
    }

    public static <Type> ClassReader<Type> get(Class<Type> type) {
        byte[] bytes = ClassReader.getBytes(type);
        return bytes == null ? null : new ClassReader<Type>(type, bytes);
    }

    public static byte[] getBytes(Class<?> type) {
        InputStream inputStream = type.getResourceAsStream('/' + type.getName().replace('.', '/') + ".class");
        if (inputStream == null) {
            return null;
        }
        try {
            int actual;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            do {
                if ((actual = inputStream.read(buf)) <= 0) continue;
                out.write(buf, 0, actual);
            } while (actual > 0);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException exception) {
                throw new IllegalStateException(exception);
            }
        }
    }

    protected static String getSignature(Member method, Class<?>[] paramTypes) {
        StringBuilder b = new StringBuilder(method instanceof Method ? method.getName() : MethodInfo.MethodType.CONSTRUCTOR.getName());
        b.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            ClassReader.addDescriptor(b, paramTypes[i]);
        }
        b.append(')');
        if (method instanceof Method) {
            ClassReader.addDescriptor(b, ((Method)method).getReturnType());
        } else if (method instanceof Constructor) {
            ClassReader.addDescriptor(b, Void.TYPE);
        }
        return b.toString().replace('.', '/');
    }

    private static void readMethodDescriptor(MethodInfo<?> methodInfo, String descriptor) {
        StringReader reader = new StringReader(descriptor);
        if (reader.read() != '(') {
            throw new IllegalArgumentException("Method descriptor must begin with '(' but got '" + descriptor + "'");
        }
        ArrayList parameterTypes = new ArrayList();
        while (reader.peek() != ')') {
            parameterTypes.add(ClassReader.readType(reader));
        }
        methodInfo.setParameterTypes(parameterTypes.toArray(new Class[parameterTypes.size()]));
        reader.skip();
        methodInfo.setReturnType(ClassReader.readType(reader));
    }

    private static Class<?> readType(StringReader reader) {
        switch (reader.read()) {
            case 'V': {
                return Void.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                String type = reader.readUntil(';', true);
                return ClassReader.toClass(type.replace('/', '.'));
            }
            case '[': {
                return ClassReader.toArray(ClassReader.readType(reader));
            }
        }
        throw new IllegalArgumentException("Unknown method signature parameter type '" + reader.peek() + "'");
    }

    private static Class<?> toClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Unknown method signature parameter type '" + name + "'");
        }
    }

    public static Class<?> toArray(Class<?> type) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        ClassReader.addDescriptor(buffer, type);
        return ClassReader.toClass(buffer.toString());
    }

    private static void addDescriptor(StringBuilder buffer, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                buffer.append('V');
            } else if (type == Integer.TYPE) {
                buffer.append('I');
            } else if (type == Boolean.TYPE) {
                buffer.append('Z');
            } else if (type == Byte.TYPE) {
                buffer.append('B');
            } else if (type == Short.TYPE) {
                buffer.append('S');
            } else if (type == Long.TYPE) {
                buffer.append('J');
            } else if (type == Character.TYPE) {
                buffer.append('C');
            } else if (type == Float.TYPE) {
                buffer.append('F');
            } else if (type == Double.TYPE) {
                buffer.append('D');
            }
        } else if (type.isArray()) {
            buffer.append('[');
            ClassReader.addDescriptor(buffer, type.getComponentType());
        } else {
            buffer.append('L').append(type.getName()).append(';');
        }
    }

    protected final int readShort() {
        return this.read() << 8 | this.read();
    }

    protected final int readInt() {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    protected void skipFully(int n) {
        while (n > 0) {
            int c = (int)this.skip(n);
            if (c <= 0) {
                throw new IllegalStateException("Unexpected end of file.");
            }
            n -= c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Member resolveMethod(int index) throws ClassNotFoundException, NoSuchMethodException {
        int oldPos = this.pos;
        try {
            Executable m = (Constructor<?>)this.cpool[index];
            if (m == null) {
                this.pos = this.cpoolIndex[index];
                Class<?> owner = this.resolveClass(this.readShort());
                NameAndType nt = this.resolveNameAndType(this.readShort());
                String signature = nt.name + nt.type;
                if (nt.name.equals(MethodInfo.MethodType.CONSTRUCTOR.getName())) {
                    Constructor<?>[] constructors = owner.getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        String sig = ClassReader.getSignature(constructors[i], constructors[i].getParameterTypes());
                        if (!sig.equals(signature)) continue;
                        this.cpool[index] = m = constructors[i];
                        Executable executable = m;
                        return executable;
                    }
                } else {
                    Method[] methods = owner.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        String sig = ClassReader.getSignature(methods[i], methods[i].getParameterTypes());
                        if (!sig.equals(signature)) continue;
                        m = methods[i];
                        this.cpool[index] = m;
                        Executable executable = m;
                        return executable;
                    }
                }
                throw new NoSuchMethodException(signature);
            }
            Constructor<?> constructor = m;
            return constructor;
        }
        finally {
            this.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Field resolveField(int i) throws ClassNotFoundException, NoSuchFieldException {
        int oldPos = this.pos;
        try {
            Field f = (Field)this.cpool[i];
            if (f == null) {
                this.pos = this.cpoolIndex[i];
                Class<?> owner = this.resolveClass(this.readShort());
                NameAndType nt = this.resolveNameAndType(this.readShort());
                f = owner.getDeclaredField(nt.name);
                this.cpool[i] = f;
            }
            Field field = f;
            return field;
        }
        finally {
            this.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NameAndType resolveNameAndType(int i) {
        int oldPos = this.pos;
        try {
            NameAndType nt = (NameAndType)this.cpool[i];
            if (nt == null) {
                this.pos = this.cpoolIndex[i];
                String name = this.resolveUtf8(this.readShort());
                String type = this.resolveUtf8(this.readShort());
                nt = new NameAndType(name, type);
                this.cpool[i] = nt;
            }
            NameAndType nameAndType = nt;
            return nameAndType;
        }
        finally {
            this.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Class<?> resolveClass(int index) throws ClassNotFoundException {
        int oldPos = this.pos;
        try {
            Class<?> type = (Class<?>)this.cpool[index];
            if (type == null) {
                this.pos = this.cpoolIndex[index];
                String name = this.resolveUtf8(this.readShort());
                this.cpool[index] = type = Class.forName(name.replace('/', '.'));
            }
            Class<?> clazz = type;
            return clazz;
        }
        finally {
            this.pos = oldPos;
        }
    }

    protected final String resolveUtf8(int index) {
        int oldPos = this.pos;
        try {
            String s = (String)this.cpool[index];
            if (s == null) {
                this.pos = this.cpoolIndex[index];
                int len = this.readShort();
                this.skipFully(len);
                s = new String(this.buf, this.pos - len, len, "utf-8");
                this.cpool[index] = s;
            }
            String string = s;
            return string;
        }
        catch (UnsupportedEncodingException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            this.pos = oldPos;
        }
    }

    protected final void readCpool() {
        int count = this.readShort();
        this.cpoolIndex = new int[count];
        this.cpool = new Object[count];
        block7: for (int i = 1; i < count; ++i) {
            int c = this.read();
            this.cpoolIndex[i] = this.pos;
            switch (c) {
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.readShort();
                }
                case 7: 
                case 8: {
                    this.readShort();
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.readInt();
                    ++i;
                }
                case 3: 
                case 4: {
                    this.readInt();
                    continue block7;
                }
                case 1: {
                    int len = this.readShort();
                    this.skipFully(len);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Unexpected class constant");
                }
            }
        }
    }

    protected final void skipAttributes() {
        int count = this.readShort();
        for (int i = 0; i < count; ++i) {
            this.readShort();
            this.skipFully(this.readInt());
        }
    }

    protected final void readAttributes(MethodInfo<Type> methodInfo) {
        int count = this.readShort();
        for (int i = 0; i < count; ++i) {
            int nameIndex = this.readShort();
            int attrLen = this.readInt();
            String attrName = this.resolveUtf8(nameIndex);
            if ("Code".equals(attrName)) {
                this.readCode(methodInfo);
                continue;
            }
            if ("LocalVariableTable".equals(attrName)) {
                this.readLocalVariableTable(methodInfo);
                continue;
            }
            this.skipFully(attrLen);
        }
    }

    public void readCode(MethodInfo<Type> methodInfo) {
        this.readShort();
        methodInfo.localVariables = this.readShort();
        this.skipFully(this.readInt());
        this.skipFully(8 * this.readShort());
        this.readAttributes(methodInfo);
    }

    private void readLocalVariableTable(MethodInfo<Type> methodInfo) {
        int first;
        int len = this.readShort();
        String[] localVariables = new String[methodInfo.localVariables];
        for (int i = 0; i < len; ++i) {
            this.readShort();
            this.readShort();
            int nameIndex = this.readShort();
            this.readShort();
            int index = this.readShort();
            localVariables[index] = this.resolveUtf8(nameIndex);
        }
        String[] parameterNames = new String[methodInfo.getParameterTypes().length];
        int i = first = Modifier.isStatic(methodInfo.getModifiers()) ? 0 : 1;
        for (int j = 0; i < localVariables.length && j < parameterNames.length; ++i, ++j) {
            parameterNames[j] = localVariables[i];
            Class<?> type = methodInfo.getParameterTypes()[j];
            if (type != Double.TYPE && type != Long.TYPE) continue;
            ++i;
        }
        methodInfo.setParameterNames(parameterNames);
    }

    public MethodInfo<Type> getMethodInfo(Constructor<Type> constructor) {
        return this.getMethodInfo(constructor, constructor.getParameterTypes());
    }

    public MethodInfo<Type> getMethodInfo(Method method) {
        return this.getMethodInfo(method, method.getParameterTypes());
    }

    private MethodInfo<Type> getMethodInfo(Member member, Class<?>[] paramTypes) {
        String signature = ClassReader.getSignature(member, paramTypes);
        MethodInfo<Type> methodInfo = this.methods.get(signature);
        return methodInfo;
    }

    private static class NameAndType {
        String name;
        String type;

        public NameAndType(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class MethodInfo<Type> {
        private Class<Type> owner;
        private int modifiers;
        private MethodType type;
        private String name;
        private Class<?>[] parameterTypes;
        private String[] parameterNames;
        private Class<?> returnType;
        int localVariables;

        public Class<Type> getOwner() {
            return this.owner;
        }

        public void setOwner(Class<Type> owner) {
            this.owner = owner;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public MethodType getType() {
            return this.type;
        }

        public void setType(MethodType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.type = MethodType.fromName(name);
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public void setParameterTypes(Class<?>[] parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        public void setParameterNames(String[] parameterNames) {
            this.parameterNames = parameterNames;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public void setReturnType(Class<?> returnType) {
            this.returnType = returnType;
        }

        public Constructor<Type> getConstructor() {
            if (this.type != MethodType.CONSTRUCTOR) {
                throw new IllegalArgumentException("Method '" + this.toString() + "' is not a constructor, use getMethod");
            }
            try {
                return this.owner.getDeclaredConstructor(this.parameterTypes);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to resolve method '" + this.toString() + "'", exception);
            }
        }

        public Method getMethod() {
            if (this.type != MethodType.METHOD) {
                throw new IllegalArgumentException("Method '" + this.toString() + "' is not a method, use getConstructor");
            }
            try {
                return this.owner.getDeclaredMethod(this.name, this.parameterTypes);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to resolve method '" + this.toString() + "'", exception);
            }
        }

        public String toString() {
            DelimiterStringBuilder buffer = new DelimiterStringBuilder();
            buffer.append(this.returnType.getName(), " ");
            buffer.append(this.owner.getName(), ".");
            buffer.append(this.name);
            buffer.append("(");
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                buffer.append(this.parameterTypes[i].getName(), " ");
                if (this.parameterNames[i] == null) {
                    buffer.append("arg" + i, ", ");
                    continue;
                }
                buffer.append(this.parameterNames[i], ", ");
            }
            buffer.clearDelimiter();
            buffer.append(")");
            return buffer.toString();
        }

        public static enum MethodType {
            STATIC_CONSTRUCTOR("<clinit>"),
            CONSTRUCTOR("<init>"),
            METHOD(null);

            private final String name;

            private MethodType(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public static MethodType fromName(String methodName) {
                for (MethodType methodType : MethodType.values()) {
                    if (!methodName.equals(methodType.name)) continue;
                    return methodType;
                }
                return METHOD;
            }
        }
    }
}

