/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.util.ClassUtils;
import com.intersult.util.collection.reference.WeakValueMap;
import com.intersult.util.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicClassLoader
extends ClassLoader {
    public static final String DYNAMIC_LOADED_CLASS_NAME = DynamicClassLoader.class.getName();
    private static Log log = LogFactory.getLog(DynamicClassLoader.class);
    private static Map<String, Class<?>> classMap = new WeakValueMap();
    private String type;

    public DynamicClassLoader() {
        this(DynamicClassLoader.class.getClassLoader(), DYNAMIC_LOADED_CLASS_NAME);
    }

    private DynamicClassLoader(ClassLoader parent, String type) {
        super(parent);
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> unload() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unload class '" + this.type + "'"));
        }
        Map<String, Class<?>> map = classMap;
        synchronized (map) {
            return classMap.remove(this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public <T> Class<T> loadClass(Class<T> type) throws ClassNotFoundException {
        return this.loadClass(type.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        if (name.startsWith("java.")) {
            return this.getParent().loadClass(name);
        }
        if (name.equals(DYNAMIC_LOADED_CLASS_NAME)) {
            return this.getClass();
        }
        Map<String, Class<?>> map = classMap;
        synchronized (map) {
            result = classMap.get(name);
            if (result == null) {
                result = new DynamicClassLoader(this.getParent(), name).load();
            }
        }
        return result;
    }

    private Class<?> load() throws ClassNotFoundException {
        byte[] bytes;
        URL url = this.getResource(ClassUtils.getClassFile((String)this.type));
        if (url == null) {
            return this.getParent().loadClass(this.type);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load class '" + this.type + "'"));
        }
        try {
            InputStream inputStream = url.openStream();
            bytes = IOUtils.read((InputStream)inputStream);
        }
        catch (IOException exception) {
            throw new ClassNotFoundException("Error loading class '" + this.type + "'", exception);
        }
        Class<?> result = this.defineClass(this.type, bytes, 0, bytes.length);
        classMap.put(this.type, result);
        return result;
    }

    public String toString() {
        ClassLoader parent = this.getParent();
        String prefix = parent instanceof DynamicClassLoader ? parent.toString() : parent.getClass().getSimpleName();
        return prefix + ":" + this.type;
    }
}

