/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.code.GeneratorException;
import com.intersult.code.Instance;
import com.intersult.code.JavaClass;
import com.intersult.code.JavaMethod;
import com.intersult.code.JavaVariable;
import com.intersult.code.Reflector;
import com.intersult.util.bean.Default;
import com.intersult.util.bean.Name;
import com.intersult.util.bean.Required;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Generator {
    public static final Pattern XML_NAME_SEPARATOR = Pattern.compile("\\-|\\.");
    private static Set<String> identifier;
    private static Set<String> numeric;

    private static Set<String> getIdentifier() {
        if (identifier == null) {
            identifier = new HashSet<String>();
            identifier.add("class");
            identifier.add("interface");
            identifier.add("enum");
            identifier.add("package");
            identifier.add("for");
            identifier.add("if");
            identifier.add("do");
            identifier.add("while");
            identifier.add("continue");
            identifier.add("volatile");
            identifier.add("transient");
            identifier.add("instanceof");
            identifier.add("super");
            identifier.add("this");
            identifier.add("synchronized");
            identifier.add("else");
            identifier.add("static");
            identifier.add("final");
            identifier.add("public");
            identifier.add("private");
            identifier.add("protected");
            identifier.add("abstract");
            identifier.add("native");
            identifier.add("implements");
            identifier.add("extends");
            identifier.add("final");
            identifier.add("int");
            identifier.add("long");
            identifier.add("char");
            identifier.add("void");
            identifier.add("byte");
            identifier.add("short");
            identifier.add("float");
            identifier.add("double");
            identifier.add("boolean");
            identifier.add("return");
            identifier.add("switch");
            identifier.add("case");
            identifier.add("break");
            identifier.add("try");
            identifier.add("catch");
            identifier.add("finally");
            identifier.add("throw");
            identifier.add("throws");
            identifier.add("const");
            identifier.add("goto");
            identifier.add("true");
            identifier.add("false");
            identifier.add("null");
            identifier.add("assert");
            identifier.add("import");
            identifier.add("default");
            identifier.add("List");
            identifier.add("Name");
        }
        return identifier;
    }

    public static Set<String> getNumeric() {
        if (numeric == null) {
            numeric = new HashSet<String>();
            numeric.add("int");
            numeric.add("long");
            numeric.add("byte");
            numeric.add("float");
            numeric.add("double");
            numeric.add("short");
        }
        return numeric;
    }

    public static String getIdentifier(String name, boolean escape) {
        String[] parts = XML_NAME_SEPARATOR.split(name);
        StringBuilder buffer = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            buffer.append(Generator.upperName(parts[i]));
        }
        name = buffer.toString();
        if (escape && !"".equals(name) && (Generator.getIdentifier().contains(name) || Character.isDigit(name.charAt(0)))) {
            name = "_" + name;
        }
        return name;
    }

    public static String getLocalName(String name) {
        if (name == null) {
            return name;
        }
        int index = name.indexOf(58);
        if (index < 0) {
            return name;
        }
        return name.substring(index + 1);
    }

    public static void generateClass(Reflector reflector, JavaClass javaClass) {
        Generator.generateClass(reflector, javaClass, null);
    }

    public static void generateClass(Reflector reflector, JavaClass javaClass, List<File> files) {
        if (javaClass.getParent() != null) {
            throw new GeneratorException("Cannot write nested JavaClass, write parent '" + javaClass.getParent().getTypeNameSimple(true) + "' instead");
        }
        File basePath = javaClass.getBasePath();
        if (basePath == null) {
            throw new IllegalArgumentException("JavaClass must have basePath set");
        }
        File file = StringUtils.isEmpty((String)javaClass.getPath()) ? new File(basePath, javaClass.getTypeNameSimple(false) + ".java") : new File(basePath, javaClass.getPath() + File.separator + javaClass.getTypeName(false) + ".java");
        file.getParentFile().getAbsoluteFile().mkdirs();
        if (files != null) {
            files.add(file);
        }
        PrintStream stream = null;
        try {
            stream = new PrintStream(file);
            if (StringUtils.isNotEmpty((String)javaClass.getPackage())) {
                stream.println("package " + javaClass.getPackage() + ";");
                stream.println();
            }
            Generator.generateImports(stream, javaClass);
            Generator.generateClass(reflector, stream, javaClass, files);
        }
        catch (FileNotFoundException exception) {
            throw new GeneratorException("Error generating class '" + javaClass.getTypeNameSimple(true), exception);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static void generateClass(Reflector reflector, PrintStream stream, JavaClass javaClass, List<File> files) {
        if (javaClass.getComment() != null) {
            Generator.generateComment(stream, javaClass);
        }
        if (javaClass.isAutoAnnotations() && javaClass.isCaseCorrection()) {
            stream.println(javaClass.getIntent() + "@" + Name.class.getSimpleName() + "(\"" + javaClass.getName() + "\")");
        }
        if (!javaClass.getAnnotations().isEmpty()) {
            Generator.generateAnnotations(stream, javaClass);
        }
        stream.print(javaClass.getIntent());
        stream.print(javaClass.getClassDefinition());
        stream.println(" {");
        for (JavaClass subClass : javaClass.getSubClasses().values()) {
            Generator.generateClass(reflector, stream, subClass, files);
        }
        if (!javaClass.getEnumConstants().isEmpty()) {
            Generator.generateEnumConstants(stream, javaClass);
        }
        if (!javaClass.getFields().isEmpty()) {
            Generator.generateFields(stream, javaClass);
        }
        if (!javaClass.getMethods().isEmpty()) {
            Generator.generateMethods(stream, javaClass, true);
        }
        if (!javaClass.getFields().isEmpty()) {
            Generator.generateAccessors(reflector, stream, javaClass);
        }
        if (!javaClass.getMethods().isEmpty()) {
            Generator.generateMethods(stream, javaClass, false);
        }
        stream.print(javaClass.getIntent());
        stream.print("}");
        if (javaClass.isSubClass()) {
            stream.println();
            stream.println();
        }
    }

    private static void generateImports(PrintStream stream, JavaClass javaClass) {
        TreeSet<String> imports = new TreeSet<String>();
        Generator.collectImports(javaClass, imports);
        if (!imports.isEmpty()) {
            String lastPrefix = null;
            for (String namespace : imports) {
                String prefix = StringUtils.substringBefore((String)namespace, (String)".");
                if (!prefix.equals(lastPrefix)) {
                    if (lastPrefix != null) {
                        stream.println();
                    }
                    lastPrefix = prefix;
                }
                stream.println("import " + namespace + ";");
            }
            stream.println();
        }
    }

    private static void collectImports(JavaClass currentClass, Set<String> imports) {
        if (currentClass.isAutoAnnotations() && currentClass.isCaseCorrection()) {
            imports.add(Name.class.getName());
        }
        if (!currentClass.getAnnotations().isEmpty()) {
            for (Instance annotation : currentClass.getAnnotations().values()) {
                Generator.collectImport(currentClass, imports, annotation.getType());
            }
        }
        if (currentClass.getExtendsClass() != null) {
            Generator.collectImport(currentClass, imports, currentClass.getExtendsClass());
        }
        for (JavaClass implementsClass : currentClass.getImplementsClasses()) {
            Generator.collectImport(currentClass, imports, implementsClass);
        }
        for (JavaVariable property : currentClass.getFields().values()) {
            for (Instance annotation : property.getAnnotations()) {
                Generator.collectImport(currentClass, imports, annotation.getType());
            }
            Generator.collectImport(currentClass, imports, property.getType());
            if (property.getValue() != null) {
                imports.add(Default.class.getName());
            }
            if (property.isRequired()) {
                imports.add(Required.class.getName());
            }
            if (!currentClass.isAutoAnnotations() || !property.isNameCorrection()) continue;
            imports.add(Name.class.getName());
        }
        if (!currentClass.getMethods().isEmpty()) {
            for (JavaMethod method : currentClass.getMethods()) {
                Generator.collectImport(currentClass, imports, method.getReturnType());
                for (JavaVariable parameter : method.getParameters().getVariables()) {
                    Generator.collectImport(currentClass, imports, parameter.getType());
                }
                for (JavaClass referencedType : method.getReferencedTypes()) {
                    Generator.collectImport(currentClass, imports, referencedType);
                }
                for (Instance annotation : method.getAnnotations().values()) {
                    Generator.collectImport(currentClass, imports, annotation.getType());
                }
                imports.addAll(method.getCodeImports());
            }
        }
        for (JavaClass subClass : currentClass.getSubClasses().values()) {
            Generator.collectImports(subClass, imports);
        }
        for (String enumConstant : currentClass.getEnumConstants()) {
            if (!currentClass.isAutoAnnotations() || enumConstant.equals(Generator.getIdentifier(enumConstant, true))) continue;
            imports.add(Name.class.getName());
        }
    }

    private static void collectImport(JavaClass currentClass, Set<String> imports, JavaClass javaClass) {
        if (javaClass != null) {
            if (!(javaClass.isJavaLang() || javaClass.getPackage() == null || javaClass.getPackage().equals(currentClass.getPackage()) && (javaClass.getParent() == null || currentClass.getRoot().equals(javaClass.getRoot())))) {
                imports.add(javaClass.getTypeNameSimple(true));
            }
            for (JavaClass typeParameter : javaClass.getTypeParameters()) {
                Generator.collectImport(currentClass, imports, typeParameter);
            }
        }
    }

    private static void generateComment(PrintStream stream, JavaClass javaClass) {
        stream.println(javaClass.getIntent() + "/**");
        stream.println(javaClass.getIntent() + "   " + javaClass.getComment());
        stream.println(javaClass.getIntent() + " **/");
    }

    private static void generateAnnotations(PrintStream stream, JavaClass javaClass) {
        for (Instance annotation : javaClass.getAnnotations().values()) {
            stream.print(javaClass.getIntent() + annotation.getAnnotationDefinition());
            stream.println();
        }
    }

    private static void generateEnumConstants(PrintStream stream, JavaClass javaClass) {
        LinkedHashSet<String> constantSet = new LinkedHashSet<String>();
        for (String constant : javaClass.getEnumConstants()) {
            constantSet.add(constant);
        }
        String[] constants = constantSet.toArray(new String[constantSet.size()]);
        int size = constants.length - 1;
        for (int i = 0; i <= size; ++i) {
            String constant = constants[i];
            String enumConstant = Generator.getIdentifier(constant, true);
            if (javaClass.isAutoAnnotations() && !constant.equals(enumConstant)) {
                stream.println(javaClass.getIntent() + "\t@" + Name.class.getSimpleName() + "(\"" + constant + "\")");
            }
            stream.print(javaClass.getIntent() + "\t" + enumConstant);
            if (i >= size) continue;
            stream.println(",");
        }
        stream.println(";");
    }

    private static void generateFields(PrintStream stream, JavaClass javaClass) {
        HashSet<String> names = new HashSet<String>();
        for (JavaVariable field : javaClass.getFields().values()) {
            if (names.contains(field.getName())) continue;
            names.add(field.getName());
            stream.print(javaClass.getIntent() + "\t");
            if (field.getVisibility() != null && field.getVisibility().getModifier() != null) {
                stream.print(field.getVisibility().getModifier() + " ");
            }
            if (field.isStatic()) {
                stream.print("static ");
            }
            if (field.isFinal()) {
                stream.print("final ");
            }
            stream.print(field.getTypeName(false) + " " + field.getVariableName());
            if (field.getInit() != null) {
                stream.print(" = " + field.getInitDefinition());
            }
            stream.println(";");
        }
    }

    private static void generateAccessors(Reflector reflector, PrintStream stream, JavaClass javaClass) {
        HashSet<String> names = new HashSet<String>();
        for (JavaVariable field : javaClass.getFields().values()) {
            if (!field.isProperty() || names.contains(field.getName())) continue;
            names.add(field.getName());
            stream.println();
            if (field.getComment() != null) {
                stream.println(javaClass.getIntent() + "\t/**");
                stream.println(javaClass.getIntent() + "\t   " + field.getComment());
                stream.println(javaClass.getIntent() + "\t **/");
            }
            if (field.isRequired()) {
                stream.println(javaClass.getIntent() + "\t" + reflector.REQUIRED.newInstance().getAnnotationDefinition());
            }
            if (field.getValue() != null) {
                Instance defaultAnnotation = reflector.DEFAULT.newInstance();
                defaultAnnotation.get("value").setValue(field.getValue());
                stream.println(javaClass.getIntent() + "\t" + defaultAnnotation.getAnnotationDefinition());
            }
            if (field.isNameCorrection()) {
                Instance nameAnnotation = reflector.NAME.newInstance();
                nameAnnotation.get("value").setValue(field.getName());
                stream.println(javaClass.getIntent() + "\t" + nameAnnotation.getAnnotationDefinition());
            }
            for (Instance annotation : field.getAnnotations()) {
                stream.println(javaClass.getIntent() + "\t" + annotation.getAnnotationDefinition());
            }
            stream.println(javaClass.getIntent() + "\tpublic " + field.getTypeName(false) + " " + field.getGetter() + "() {");
            stream.println(javaClass.getIntent() + "\t\treturn " + field.getVariableName() + ";");
            stream.println(javaClass.getIntent() + "\t}");
            if (field.isReadOnly()) continue;
            stream.println(javaClass.getIntent() + "\tpublic void " + field.getSetter() + "(" + field.getTypeName(false) + " " + field.getVariableName() + ") {");
            stream.println(javaClass.getIntent() + "\t\tthis." + field.getVariableName() + " = " + field.getVariableName() + ";");
            stream.println(javaClass.getIntent() + "\t}");
        }
    }

    private static void generateMethods(PrintStream stream, JavaClass javaClass, boolean constructors) {
        if (!javaClass.getFields().isEmpty()) {
            stream.println();
        }
        for (JavaMethod method : javaClass.getMethods()) {
            if (method.isConstructor() != constructors) continue;
            for (Instance annotation : method.getAnnotations().values()) {
                stream.print(javaClass.getIntent() + "\t" + annotation.getAnnotationDefinition());
                stream.println();
            }
            stream.println(javaClass.getIntent() + "\t" + method.getDefinition(false) + " {");
            for (String codeLine : method.getCode()) {
                stream.println(javaClass.getIntent() + "\t\t" + codeLine);
            }
            stream.println(javaClass.getIntent() + "\t}");
        }
    }

    public static String upperName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String lowerName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static String staticName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        StringBuilder buffer = new StringBuilder();
        if (!Character.isLetter(name.charAt(0))) {
            buffer.append("_");
        }
        buffer.append(Character.toUpperCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isUpperCase(name.charAt(i)) && Character.isLowerCase(name.charAt(i - 1))) {
                buffer.append("_");
            }
            buffer.append(Character.toUpperCase(name.charAt(i)));
        }
        return buffer.toString();
    }
}

