/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.code.JavaClass;
import com.intersult.code.JavaMethod;
import com.intersult.code.JavaVariable;
import com.intersult.code.Scope;
import com.intersult.util.bean.CustomInstance;
import com.intersult.util.bean.Transient;
import java.util.List;

public class Instance
extends Scope
implements CustomInstance {
    private JavaClass type;

    public Instance(JavaClass type) {
        this.type = type;
        if (type.getDefinition() == JavaClass.Definition.ANNOTATION) {
            for (JavaMethod javaMethod : type.getMethods()) {
                JavaVariable variable = new JavaVariable(javaMethod.getReturnType(), javaMethod.getName());
                this.add(variable);
            }
        } else {
            for (JavaClass.Accessor accessor : type.getAccessors().values()) {
                if (accessor.isStatic()) continue;
                JavaVariable variable = new JavaVariable(accessor.getType(), accessor.getName());
                this.add(variable);
            }
        }
    }

    @Override
    public JavaVariable get(String name) {
        return super.get(name);
    }

    public JavaClass getType() {
        return this.type;
    }

    @Transient
    public String getDefinition() {
        if (this.type.getDefinition() == JavaClass.Definition.ANNOTATION) {
            return this.getAnnotationDefinition();
        }
        return this.getClassDefinition();
    }

    @Transient
    public String getClassDefinition() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("new ");
        buffer.append(this.type.getTypeName(false));
        buffer.append("(");
        buffer.append(this.getActualDefinition());
        buffer.append(")");
        return buffer.toString();
    }

    @Transient
    public String getAnnotationDefinition() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@");
        buffer.append(this.type.getTypeName(false));
        List<JavaVariable> assigned = this.getAssigned();
        if (assigned.size() > 0) {
            buffer.append("(");
            if (assigned.size() == 1 && "value".equals(assigned.get(0).getName())) {
                buffer.append(assigned.get(0).getValueDefinition());
            } else {
                buffer.append(this.getAssignDefinition());
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return this.getDefinition();
    }
}

