/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.code.ClassReader;
import com.intersult.code.Generator;
import com.intersult.code.Instance;
import com.intersult.code.JavaMethod;
import com.intersult.code.JavaVariable;
import com.intersult.code.Visibility;
import com.intersult.util.bean.CustomType;
import com.intersult.util.bean.Property;
import com.intersult.util.bean.Transient;
import com.intersult.util.string.DelimiterStringBuilder;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class JavaClass
implements Cloneable,
CustomType {
    private File basePath;
    private String path;
    private String name;
    private String packageName;
    private Map<String, JavaClass> subClasses;
    private Map<String, JavaVariable> fields;
    private List<JavaMethod> methods;
    private Map<String, Accessor> declaredAccessors;
    private Map<String, Accessor> accessors;
    private Map<JavaClass, Instance> annotations;
    private List<String> enumConstants;
    private List<JavaClass> typeParameters;
    private List<JavaClass> implementsClasses;
    private JavaClass extendsClass;
    private String comment;
    private boolean _abstract;
    private boolean _static;
    private boolean _final;
    private Visibility visibility = Visibility.PUBLIC;
    private Definition definition = Definition.CLASS;
    private JavaClass parent;
    private boolean escape = true;
    private boolean keepCase;
    private boolean autoAnnotations;
    private List<JavaClass> lowerBounds;
    private List<JavaClass> upperBounds;
    private boolean frozen;
    private boolean array;
    private Boolean primitive;

    public JavaClass() {
    }

    public JavaClass(String packageName, String name) {
        this.name = name;
        this.packageName = packageName;
    }

    public JavaClass(String packageName, String name, Definition definition) {
        this(packageName, name);
        this.definition = definition;
    }

    private JavaClass(File basePath, String path, String name, String packageName, Map<String, JavaClass> subClasses, Map<String, JavaVariable> fields, List<JavaMethod> methods, Map<JavaClass, Instance> annotations, List<String> enumConstants, List<JavaClass> typeParameters, List<JavaClass> implementsClasses, JavaClass extendsClass, String comment, boolean _abstract, boolean _final, Definition definition, JavaClass parent, boolean escape, boolean keepCase, boolean autoAnnotations, List<JavaClass> lowerBounds, List<JavaClass> upperBounds, boolean array) {
        this.basePath = basePath;
        this.path = path;
        this.name = name;
        this.packageName = packageName;
        this.subClasses = subClasses;
        this.fields = fields;
        this.methods = methods;
        this.annotations = annotations;
        this.enumConstants = enumConstants;
        this.typeParameters = typeParameters;
        this.implementsClasses = implementsClasses;
        this.extendsClass = extendsClass;
        this.comment = comment;
        this._abstract = _abstract;
        this._final = _final;
        this.definition = definition;
        this.parent = parent;
        this.escape = escape;
        this.keepCase = keepCase;
        this.autoAnnotations = autoAnnotations;
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
        this.array = array;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    @Transient
    public boolean isJavaLang() {
        return "java.lang".equals(this.packageName);
    }

    public Map<String, JavaClass> getSubClasses() {
        if (this.subClasses == null) {
            this.subClasses = new LinkedHashMap<String, JavaClass>();
        }
        return this.subClasses;
    }

    public void setSubClasses(Map<String, JavaClass> subClasses) {
        this.subClasses = subClasses;
    }

    public Map<String, JavaVariable> getFields() {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, JavaVariable>();
        }
        return this.fields;
    }

    public void setFields(Map<String, JavaVariable> fields) {
        this.fields = fields;
    }

    public void addField(JavaVariable field) {
        this.getFields().put(field.getName(), field);
    }

    public List<JavaMethod> getMethods() {
        if (this.methods == null) {
            this.methods = new ArrayList<JavaMethod>();
        }
        return this.methods;
    }

    public void setMethods(List<JavaMethod> methods) {
        this.methods = methods;
    }

    public Map<String, Accessor> getAccessors() {
        if (this.accessors == null) {
            this.accessors = new LinkedHashMap<String, Accessor>();
            if (this.extendsClass != null) {
                this.accessors.putAll(this.extendsClass.getAccessors());
            }
            this.accessors.putAll(this.getDeclaredAccessors());
        }
        return this.accessors;
    }

    public Map<String, Accessor> getDeclaredAccessors() {
        if (this.declaredAccessors == null) {
            this.declaredAccessors = new LinkedHashMap<String, Accessor>();
            for (Accessor accessor : this.getDeclaredAccessorsInternal()) {
                this.declaredAccessors.put(accessor.getName(), accessor);
            }
        }
        return this.declaredAccessors;
    }

    private Collection<Accessor> getDeclaredAccessorsInternal() {
        LinkedHashMap<String, Accessor> declaredAccessors = new LinkedHashMap<String, Accessor>();
        for (JavaMethod method : this.getMethods()) {
            Accessor accessor;
            if (method.isPrivate()) continue;
            if (method.isGetter()) {
                accessor = this.getAccessor(declaredAccessors, method);
                accessor.setGetter(method);
                continue;
            }
            if (!method.isSetter()) continue;
            accessor = this.getAccessor(declaredAccessors, method);
            accessor.setSetter(method);
        }
        return declaredAccessors.values();
    }

    private Accessor getAccessor(Map<String, Accessor> declaredAccessors, JavaMethod method) {
        String name = method.getAccessorName();
        Accessor accessor = declaredAccessors.get(name);
        if (accessor == null) {
            accessor = new Accessor();
            accessor.setName(name);
            accessor.setType(method.getAccessorType());
            accessor.setStatic(method.isStatic());
            declaredAccessors.put(name, accessor);
        }
        if (method.getAnnotatedName() != null) {
            accessor.setName(method.getAnnotatedName());
        }
        return accessor;
    }

    public Accessor addAccessor(JavaClass type, String name) {
        Accessor accessor = new Accessor();
        accessor.setType(type);
        accessor.setName(name);
        String readMethodName = ("boolean".equals(type.getTypeNameSimple(true)) ? "is" : "get") + Generator.upperName(name);
        JavaMethod readMethod = this.addMethod(readMethodName);
        readMethod.setReturnType(type);
        accessor.setGetter(readMethod);
        String writeMethodName = "set" + Generator.upperName(name);
        JavaMethod writeMethod = this.addMethod(writeMethodName);
        writeMethod.getParameters().add(new JavaVariable(type, name));
        accessor.setSetter(writeMethod);
        return accessor;
    }

    public Map<JavaClass, Instance> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new LinkedHashMap<JavaClass, Instance>();
        }
        return this.annotations;
    }

    public void setAnnotations(Map<JavaClass, Instance> annotations) {
        this.annotations = annotations;
    }

    public void addAnnotations(Collection<? extends Instance> annotations) {
        for (Instance instance : annotations) {
            this.addAnnotation(instance);
        }
    }

    public void addAnnotation(Instance annotation) {
        this.getAnnotations().put(annotation.getType(), annotation);
    }

    public List<String> getEnumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = new ArrayList<String>();
        }
        return this.enumConstants;
    }

    public void setEnumConstants(List<String> enumConstants) {
        this.enumConstants = enumConstants;
    }

    public List<JavaClass> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = new ArrayList<JavaClass>();
        }
        return this.typeParameters;
    }

    public void setTypeParameters(List<JavaClass> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public JavaClass getExtendsClass() {
        return this.extendsClass;
    }

    public void setExtendsClass(JavaClass extendsClass) {
        this.extendsClass = extendsClass;
    }

    public List<JavaClass> getImplementsClasses() {
        if (this.implementsClasses == null) {
            this.implementsClasses = new ArrayList<JavaClass>();
        }
        return this.implementsClasses;
    }

    public void setImplementsClasses(List<JavaClass> implementsClasses) {
        this.implementsClasses = implementsClasses;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean _abstract) {
        this._abstract = _abstract;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean _static) {
        this._static = _static;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public void visit(TypeVisitor visitor) {
        this.visit(visitor, Role.CLASS);
    }

    private void visit(TypeVisitor visitor, Role role) {
        boolean recurse = visitor.visit(this, role);
        if (recurse) {
            visitor.begin(this, Role.TYPE_PARAMETER);
            for (JavaClass typeParameter : this.getTypeParameters()) {
                typeParameter.visit(visitor, Role.TYPE_PARAMETER);
            }
            visitor.end(this, Role.TYPE_PARAMETER);
            visitor.begin(this, Role.LOWER_BOUND);
            for (JavaClass lowerBound : this.getLowerBounds()) {
                lowerBound.visit(visitor, Role.LOWER_BOUND);
            }
            visitor.end(this, Role.LOWER_BOUND);
            visitor.begin(this, Role.UPPER_BOUND);
            for (JavaClass upperBound : this.getUpperBounds()) {
                upperBound.visit(visitor, Role.UPPER_BOUND);
            }
            visitor.end(this, Role.UPPER_BOUND);
            visitor.begin(this, Role.SUB_CLASS);
            for (JavaClass subClass : this.getSubClasses().values()) {
                subClass.visit(visitor, Role.SUB_CLASS);
            }
            visitor.end(this, Role.SUB_CLASS);
        }
    }

    @Transient
    public String getTypeName(final boolean qualify) {
        LimitedVisitor visitor = new LimitedVisitor(){
            private DelimiterStringBuilder buffer = new DelimiterStringBuilder();

            @Override
            public void begin(JavaClass javaClass, Role role) {
                this.buffer.push();
                if (role == Role.TYPE_PARAMETER) {
                    if (!javaClass.getTypeParameters().isEmpty()) {
                        this.buffer.append("<");
                    }
                } else if (role == Role.LOWER_BOUND) {
                    if (!javaClass.getLowerBounds().isEmpty()) {
                        this.buffer.append(" super ");
                    }
                } else if (role == Role.UPPER_BOUND && !javaClass.getUpperBounds().isEmpty()) {
                    this.buffer.append(" extends ");
                }
            }

            @Override
            public boolean visit(JavaClass javaClass, Role role, boolean recurse) {
                if (role == Role.CLASS) {
                    this.buffer.append(JavaClass.this.getTypeNameSimple(qualify));
                } else if (role == Role.TYPE_PARAMETER) {
                    this.buffer.append(javaClass.getTypeNameSimple(qualify), ", ");
                } else if (role == Role.LOWER_BOUND) {
                    this.buffer.append(javaClass.getTypeNameSimple(qualify), " & ");
                } else if (role == Role.UPPER_BOUND) {
                    this.buffer.append(javaClass.getTypeNameSimple(qualify), " & ");
                } else if (role == Role.SUB_CLASS) {
                    return false;
                }
                return true;
            }

            @Override
            public void end(JavaClass javaClass, Role role) {
                this.buffer.clearDelimiter();
                if (role == Role.TYPE_PARAMETER) {
                    if (!javaClass.getTypeParameters().isEmpty()) {
                        this.buffer.append(">");
                    }
                    if (javaClass.isArray()) {
                        this.buffer.append("[]");
                    }
                }
                this.buffer.pop();
            }

            public String toString() {
                return this.buffer.toString();
            }
        };
        this.visit(visitor);
        return visitor.toString();
    }

    @Transient
    public String getTypeNameSimple(boolean qualify) {
        if (!qualify) {
            return this.getTypeNameSimple();
        }
        DelimiterStringBuilder buffer = new DelimiterStringBuilder(".");
        buffer.append(this.packageName);
        JavaClass.getImportAddParent(buffer, this);
        return buffer.toString();
    }

    @Transient
    public String getLoaderTypeName() {
        DelimiterStringBuilder buffer = new DelimiterStringBuilder("$");
        buffer.append(this.packageName, ".");
        JavaClass.getImportAddParent(buffer, this);
        return buffer.toString();
    }

    @Transient
    private static void getImportAddParent(DelimiterStringBuilder buffer, JavaClass javaClass) {
        if (javaClass == null) {
            return;
        }
        JavaClass.getImportAddParent(buffer, javaClass.getParent());
        buffer.append(javaClass.getTypeNameSimple());
    }

    @Transient
    private String getTypeNameSimple() {
        return Generator.getIdentifier(this.keepCase ? this.name : Generator.upperName(this.name), this.escape);
    }

    @Transient
    public Class<?> getType() {
        Class<?> type = this.getComponentType();
        if (this.isArray()) {
            type = ClassReader.toArray(type);
        }
        return type;
    }

    @Transient
    public Class<?> getComponentType() {
        try {
            String name = this.getLoaderTypeName();
            if ("void".equals(name)) {
                return Void.TYPE;
            }
            if ("int".equals(name)) {
                return Integer.TYPE;
            }
            if ("boolean".equals(name)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(name)) {
                return Byte.TYPE;
            }
            if ("short".equals(name)) {
                return Short.TYPE;
            }
            if ("long".equals(name)) {
                return Long.TYPE;
            }
            if ("char".equals(name)) {
                return Character.TYPE;
            }
            if ("float".equals(name)) {
                return Float.TYPE;
            }
            if ("double".equals(name)) {
                return Double.TYPE;
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    public JavaMethod addMethod(String name) {
        JavaMethod method = new JavaMethod(this, name);
        this.addMethod(method);
        return method;
    }

    public JavaMethod addConstructor() {
        JavaMethod method = new JavaMethod(this, this.getTypeNameSimple(false));
        this.addMethod(method);
        return method;
    }

    private void addMethod(JavaMethod method) {
        if (this.methods == null) {
            this.methods = new ArrayList<JavaMethod>();
        }
        this.methods.add(method);
    }

    @Transient
    public String getVariableName() {
        return Generator.getIdentifier(Generator.lowerName(this.name), true);
    }

    @Transient
    public boolean isCaseCorrection() {
        return !this.name.equals(this.getTypeNameSimple(false));
    }

    public JavaClass getParent() {
        return this.parent;
    }

    public void setParent(JavaClass parent) {
        this.parent = parent;
        if (parent != null) {
            parent.getSubClasses().put(this.getName(), this);
        }
    }

    @Transient
    public JavaClass getRoot() {
        JavaClass javaClass = this;
        while (javaClass.getParent() != null) {
            javaClass = javaClass.getParent();
        }
        return javaClass;
    }

    @Transient
    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    @Transient
    public String getIntent() {
        return StringUtils.repeat((String)"\t", (int)this.getLevel());
    }

    @Transient
    public boolean isSubClass() {
        return this.parent != null;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setKeepCase(boolean keepCase) {
        this.keepCase = keepCase;
    }

    public boolean isKeepCase() {
        return this.keepCase;
    }

    public boolean isAutoAnnotations() {
        return this.autoAnnotations;
    }

    public void setAutoAnnotations(boolean autoAnnotations) {
        this.autoAnnotations = autoAnnotations;
    }

    public List<JavaClass> getLowerBounds() {
        if (this.lowerBounds == null) {
            this.lowerBounds = new ArrayList<JavaClass>();
        }
        return this.lowerBounds;
    }

    public void setLowerBounds(List<JavaClass> lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    public List<JavaClass> getUpperBounds() {
        if (this.upperBounds == null) {
            this.upperBounds = new ArrayList<JavaClass>();
        }
        return this.upperBounds;
    }

    public void setUpperBounds(List<JavaClass> upperBounds) {
        this.upperBounds = upperBounds;
    }

    @Transient
    public boolean isAssignableFrom(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        if (this.definition == Definition.TYPE_VARIABLE || this.definition == Definition.WILDCARD) {
            for (JavaClass bound : this.getUpperBounds()) {
                if (bound.isAssignableFrom(javaClass)) continue;
                return false;
            }
            return true;
        }
        if (javaClass.definition == Definition.TYPE_VARIABLE || javaClass.definition == Definition.WILDCARD) {
            for (JavaClass bound : this.getLowerBounds()) {
                if (this.isAssignableFrom(bound)) continue;
                return false;
            }
            return true;
        }
        if (this.getTypeNameSimple(true).equals(javaClass.getTypeNameSimple(true))) {
            return this.isParameterizable(javaClass.getTypeParameters());
        }
        if (this.isAssignableFrom(javaClass.getExtendsClass())) {
            return true;
        }
        for (JavaClass implementsClass : javaClass.getImplementsClasses()) {
            if (!this.isAssignableFrom(implementsClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    @Transient
    public String getClassDefinition() {
        DelimiterStringBuilder buffer = new DelimiterStringBuilder(" ");
        if (this.getDefinition() != Definition.TYPE_VARIABLE && this.getDefinition() != Definition.WILDCARD) {
            buffer.append(this.getVisibility().getModifier());
        }
        if (this.isAbstract()) {
            buffer.append("abstract");
        }
        if (this.isStatic()) {
            buffer.append("static");
        }
        if (this.isFinal()) {
            buffer.append("final");
        }
        buffer.append(this.getDefinition().getDefinition());
        buffer.append(this.getTypeName(false));
        if (this.getExtendsClass() != null) {
            buffer.append("extends");
            buffer.append(this.getExtendsClass().getTypeName(false));
        }
        if (!this.getImplementsClasses().isEmpty()) {
            buffer.append("implements");
            for (JavaClass implementsClass : this.getImplementsClasses()) {
                if (implementsClass.getDefinition() != Definition.INTERFACE) {
                    throw new IllegalArgumentException("Implements type '" + implementsClass.getTypeName(false) + "' must be interface definition");
                }
                buffer.append(implementsClass.getTypeName(false), ", ");
            }
        }
        return buffer.toString();
    }

    @Transient
    public Set<JavaClass> getImplementsClassesTransient() {
        HashSet<JavaClass> implementsClassesTransient = new HashSet<JavaClass>();
        this.addImplementsClassesTransient(implementsClassesTransient);
        return implementsClassesTransient;
    }

    private void addImplementsClassesTransient(Set<JavaClass> implementsClassesTransient) {
        if (this.implementsClasses != null) {
            for (JavaClass implementsClass : this.implementsClasses) {
                implementsClassesTransient.add(implementsClass);
                implementsClass.addImplementsClassesTransient(implementsClassesTransient);
            }
        }
        if (this.extendsClass != null) {
            this.extendsClass.addImplementsClassesTransient(implementsClassesTransient);
        }
    }

    public void removeRedundantInterfaces() {
        if (this.extendsClass == null || this.implementsClasses == null) {
            return;
        }
        Set<JavaClass> implementsClassesTransient = this.extendsClass.getImplementsClassesTransient();
        int i = 0;
        while (i < this.implementsClasses.size()) {
            if (implementsClassesTransient.contains(this.implementsClasses.get(i))) {
                this.implementsClasses.remove(i);
                continue;
            }
            ++i;
        }
    }

    public JavaClass parameterize(List<JavaClass> typeParameters) {
        if (this.frozen && !this.isParameterizable(typeParameters)) {
            DelimiterStringBuilder buffer = new DelimiterStringBuilder(", ");
            for (JavaClass javaClass : typeParameters) {
                buffer.append(javaClass.getTypeName(false));
            }
            throw new IllegalArgumentException("Error parameterizing type '" + this.getTypeName(false) + "' with parameters " + buffer.toString());
        }
        JavaClass javaClass = this.clone();
        javaClass.setTypeParameters(typeParameters);
        return javaClass;
    }

    public JavaClass parameterize(JavaClass ... typeParameters) {
        if (!this.isParameterizable(typeParameters)) {
            DelimiterStringBuilder buffer = new DelimiterStringBuilder(", ");
            for (JavaClass javaClass : typeParameters) {
                buffer.append(javaClass.getTypeName(false));
            }
            throw new IllegalArgumentException("Error parameterizing type '" + this.getTypeName(false) + "' with parameters " + buffer.toString());
        }
        JavaClass javaClass = this.clone();
        javaClass.setTypeParameters(Arrays.asList(typeParameters));
        return javaClass;
    }

    public boolean isParameterizable(List<JavaClass> typeParameters) {
        if (this.getTypeParameters().size() != typeParameters.size()) {
            return false;
        }
        for (int i = 0; i < typeParameters.size(); ++i) {
            if (this.getTypeParameters().get(i).isAssignableFrom(typeParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isParameterizable(JavaClass ... typeParameters) {
        if (this.getTypeParameters().size() != typeParameters.length) {
            return false;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            if (this.getTypeParameters().get(i).isAssignableFrom(typeParameters[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public void freeze() {
        this.frozen = true;
    }

    public Instance newInstance() {
        return new Instance(this);
    }

    @Transient
    public boolean isPrimitive() {
        if (this.primitive != null) {
            return this.primitive;
        }
        Class<?> type = this.getType();
        if (type == null) {
            return false;
        }
        return Property.isPrimitive(type);
    }

    public void setPrimitive(Boolean primitive) {
        this.primitive = primitive;
    }

    @Transient
    public boolean isVoid() {
        return "void".equals(this.getTypeNameSimple(true));
    }

    public void generatePath() {
        this.path = this.packageName.replace('.', File.separatorChar);
    }

    public JavaClass clone() {
        return new JavaClass(this.basePath, this.path, this.name, this.packageName, this.subClasses, this.fields, this.methods, this.annotations, this.enumConstants, this.typeParameters, this.implementsClasses, this.extendsClass, this.comment, this._abstract, this._final, this.definition, this.parent, this.escape, this.keepCase, this.autoAnnotations, this.lowerBounds, this.upperBounds, this.array);
    }

    public int hashCode() {
        return this.getTypeNameSimple(true).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)obj;
        return this.getTypeNameSimple(true).equals(javaClass.getTypeNameSimple(true));
    }

    public String toString() {
        return this.getClassDefinition();
    }

    public static enum Role {
        CLASS,
        TYPE_PARAMETER,
        SUB_CLASS,
        LOWER_BOUND,
        UPPER_BOUND;

    }

    public static abstract class LimitedVisitor
    implements TypeVisitor {
        private Set<JavaClass> stack = new HashSet<JavaClass>();

        @Override
        public final boolean visit(JavaClass javaClass, Role role) {
            boolean recurse = this.stack.add(javaClass);
            recurse &= this.visit(javaClass, role, recurse);
            return recurse;
        }

        public abstract boolean visit(JavaClass var1, Role var2, boolean var3);
    }

    public static interface TypeVisitor {
        public void begin(JavaClass var1, Role var2);

        public boolean visit(JavaClass var1, Role var2);

        public void end(JavaClass var1, Role var2);
    }

    public static class Accessor {
        private JavaClass type;
        private String name;
        private JavaMethod getter;
        private JavaMethod setter;
        private boolean _static;

        public JavaClass getType() {
            return this.type;
        }

        public void setType(JavaClass type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JavaMethod getGetter() {
            return this.getter;
        }

        public void setGetter(JavaMethod getter) {
            this.getter = getter;
        }

        public JavaMethod getSetter() {
            return this.setter;
        }

        public void setSetter(JavaMethod setter) {
            this.setter = setter;
        }

        public boolean isStatic() {
            return this._static;
        }

        public void setStatic(boolean _static) {
            this._static = _static;
        }

        public String getComment() {
            if (this.getter != null) {
                return this.getter.getComment();
            }
            if (this.setter != null) {
                return this.setter.getComment();
            }
            return null;
        }

        public void setComment(String comment) {
            if (this.getter != null) {
                this.getter.setComment(comment);
            } else if (this.setter != null) {
                this.setter.setComment(comment);
            }
        }

        public Map<JavaClass, Instance> getAnnotation() {
            if (this.getter == null) {
                return Collections.EMPTY_MAP;
            }
            return this.getter.getAnnotations();
        }

        public String toString() {
            return (this._static ? "static " : "") + this.type.getTypeNameSimple(false) + " " + this.name;
        }
    }

    public static enum Definition {
        CLASS("class", false),
        ENUM("enum", false),
        INTERFACE("interface", false),
        ANNOTATION("@interface", false),
        TYPE_VARIABLE(null, true),
        WILDCARD(null, true);

        private final String definition;
        private boolean variable;

        private Definition(String definition, boolean variable) {
            this.definition = definition;
            this.variable = variable;
        }

        public static Definition fromType(Type type) {
            if (type instanceof TypeVariable) {
                return TYPE_VARIABLE;
            }
            if (type instanceof WildcardType) {
                return WILDCARD;
            }
            if (type instanceof ParameterizedType) {
                return Definition.fromClass((Class)((ParameterizedType)type).getRawType());
            }
            return Definition.fromClass((Class)type);
        }

        public static Definition fromClass(Class<?> type) {
            if (type.isAnnotation()) {
                return ANNOTATION;
            }
            if (type.isInterface()) {
                return INTERFACE;
            }
            if (type.isEnum()) {
                return ENUM;
            }
            return CLASS;
        }

        public String getDefinition() {
            return this.definition;
        }

        public boolean isVariable() {
            return this.variable;
        }
    }
}

