/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.code.Generator;
import com.intersult.code.Instance;
import com.intersult.code.JavaClass;
import com.intersult.code.JavaVariable;
import com.intersult.code.Scope;
import com.intersult.code.Visibility;
import com.intersult.util.bean.Transient;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaMethod {
    private JavaClass owner;
    private JavaClass returnType;
    private Scope parameters;
    private List<JavaClass> referencedTypes;
    private Map<JavaClass, Instance> annotations;
    private String name;
    private List<String> code;
    private Visibility visibility = Visibility.PUBLIC;
    private Set<String> codeImports;
    private boolean _private;
    private boolean _static;
    private Method method;
    private String annotatedName;
    private String comment;

    public JavaMethod() {
    }

    JavaMethod(JavaClass owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    @Transient
    public JavaClass getOwner() {
        return this.owner;
    }

    public void setOwner(JavaClass owner) {
        this.owner = owner;
    }

    public JavaClass getReturnType() {
        return this.returnType;
    }

    public void setReturnType(JavaClass returnType) {
        this.returnType = returnType;
    }

    public Scope getParameters() {
        if (this.parameters == null) {
            this.parameters = new Scope();
        }
        return this.parameters;
    }

    public void setParameters(Scope parameters) {
        this.parameters = parameters;
    }

    public List<JavaClass> getReferencedTypes() {
        if (this.referencedTypes == null) {
            this.referencedTypes = new ArrayList<JavaClass>();
        }
        return this.referencedTypes;
    }

    public void setReferencedTypes(List<JavaClass> referencedTypes) {
        this.referencedTypes = referencedTypes;
    }

    public Map<JavaClass, Instance> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new LinkedHashMap<JavaClass, Instance>();
        }
        return this.annotations;
    }

    public void setAnnotations(Map<JavaClass, Instance> annotations) {
        this.annotations = annotations;
    }

    public void addAnnotations(Collection<? extends Instance> annotations) {
        for (Instance instance : annotations) {
            this.addAnnotation(instance);
        }
    }

    public void addAnnotation(Instance annotation) {
        this.getAnnotations().put(annotation.getType(), annotation);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<String>();
        }
        return this.code;
    }

    public void setCode(List<String> code) {
        this.code = code;
    }

    @Transient
    public boolean isConstructor() {
        return this.name.equals(this.owner.getTypeNameSimple(false));
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Set<String> getCodeImports() {
        if (this.codeImports == null) {
            this.codeImports = new LinkedHashSet<String>();
        }
        return this.codeImports;
    }

    public void setCodeImports(Set<String> codeImports) {
        this.codeImports = codeImports;
    }

    @Transient
    public boolean isAccessor() {
        return this.isGetter() || this.isSetter();
    }

    @Transient
    public boolean isGetter() {
        return (this.name.startsWith("get") || this.name.startsWith("is")) && this.getParameters().size() == 0;
    }

    @Transient
    public boolean isSetter() {
        return this.name.startsWith("set") && this.getParameters().size() == 1;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public void setPrivate(boolean _private) {
        this._private = _private;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean _static) {
        this._static = _static;
    }

    @Transient
    public String getAccessorName() {
        if (this.name.startsWith("get") || this.name.startsWith("set")) {
            return Generator.lowerName(this.name.substring(3));
        }
        if (this.name.startsWith("is")) {
            return Generator.lowerName(this.name.substring(2));
        }
        throw new IllegalStateException("Method '" + this.name + "' is not an accessor");
    }

    public String getAnnotatedName() {
        return this.annotatedName;
    }

    public void setAnnotatedName(String annotatedName) {
        this.annotatedName = annotatedName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Transient
    public JavaClass getAccessorType() {
        if (this.isGetter()) {
            return this.getReturnType();
        }
        if (this.isSetter()) {
            return this.getParameters().getVariables().get(0).getType();
        }
        throw new IllegalStateException("Method '" + this.name + "' is not an accessor");
    }

    @Transient
    public Method getMethod() {
        if (this.method == null) {
            Class<?> type = this.getOwner().getType();
            try {
                Class[] parameterTypes = this.parameters.getTypes().toArray(new Class[this.parameters.size()]);
                this.method = type.getMethod(this.name, parameterTypes);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.method;
    }

    @Transient
    public String getDefinition(boolean qualify) {
        StringBuilder buffer = new StringBuilder();
        if (this.visibility != null) {
            buffer.append(this.visibility.getModifier());
            buffer.append(" ");
        }
        if (this._static) {
            buffer.append("static ");
        }
        if (this.returnType != null) {
            buffer.append(this.returnType.getTypeName(qualify));
            buffer.append(" ");
        }
        if (qualify) {
            buffer.append(this.owner.getTypeName(qualify));
            buffer.append(".");
        }
        buffer.append(this.name);
        buffer.append("(");
        int index = 0;
        for (JavaVariable parameter : this.getParameters().getVariables()) {
            if (index++ > 0) {
                buffer.append(", ");
            }
            buffer.append(parameter.getDefinition(false));
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String toString() {
        return this.getDefinition(false);
    }
}

