/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.code.Generator;
import com.intersult.code.Instance;
import com.intersult.code.JavaClass;
import com.intersult.code.Visibility;
import com.intersult.util.bean.CustomVariable;
import com.intersult.util.bean.Transient;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaVariable
implements CustomVariable {
    private JavaClass type;
    private String name;
    private Object value;
    private boolean required;
    private boolean property;
    private boolean readOnly;
    private boolean _static;
    private boolean _final;
    private boolean skipNameCorrection;
    private Visibility visibility = Visibility.PRIVATE;
    private Object init;
    private String comment;
    private List<Instance> annotations;

    public JavaVariable() {
    }

    public JavaVariable(JavaClass javaClass) {
        this(javaClass, null);
    }

    public JavaVariable(JavaClass javaClass, String name) {
        this.type = javaClass;
        this.name = name == null ? javaClass.getVariableName() : name;
    }

    public JavaClass getType() {
        return this.type;
    }

    public void setType(JavaClass type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isProperty() {
        return this.property;
    }

    public void setProperty(boolean property) {
        this.property = property;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean _static) {
        this._static = _static;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }

    public boolean isSkipNameCorrection() {
        return this.skipNameCorrection;
    }

    public void setSkipNameCorrection(boolean skipNameCorrection) {
        this.skipNameCorrection = skipNameCorrection;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Object getInit() {
        return this.init;
    }

    @Transient
    public String getInitDefinition() {
        return JavaVariable.getConstant(this.init);
    }

    public void setInit(Object object) {
        this.init = object;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Transient
    public String getVariableName() {
        if (this.skipNameCorrection) {
            return this.name;
        }
        return Generator.getIdentifier(this._static ? Generator.staticName(this.name) : Generator.lowerName(this.name), true);
    }

    @Transient
    public boolean isNameCorrection() {
        return !this.name.equals(this.getVariableName());
    }

    @Transient
    public String getGetter() {
        String getter = ("boolean".equals(this.getTypeName(false)) ? "is" : "get") + Generator.getIdentifier(Generator.upperName(this.name), false);
        if ("getClass".equals(getter)) {
            getter = "getClass1";
        }
        return this._static ? "static " + getter : getter;
    }

    @Transient
    public String getSetter() {
        String setter = "set" + Generator.getIdentifier(Generator.upperName(this.name), false);
        if ("setClass".equals(setter)) {
            setter = "setClass1";
        }
        return setter;
    }

    @Transient
    public String getDefinition(boolean qualify) {
        return this.getQualifier() + this.getTypeName(qualify) + " " + this.getVariableName();
    }

    @Transient
    public String getDefinitionAssigned() {
        String definition = this.getDefinition(false) + " = ";
        definition = this.init == null ? definition + "new " + this.getTypeName(false) + "()" : definition + this.init;
        return definition;
    }

    @Transient
    public String getAssignment() {
        return this.getVariableName() + " = " + this.getValueDefinition();
    }

    @Transient
    public String getTypeName(boolean qualify) {
        return this.type.getTypeName(qualify);
    }

    @Transient
    public String getQualifier() {
        StringBuilder buffer = new StringBuilder();
        if (this._static) {
            buffer.append("static ");
        }
        if (this._final) {
            buffer.append("final ");
        }
        return buffer.toString();
    }

    public List<Instance> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<Instance>();
        }
        return this.annotations;
    }

    public void setAnnotations(List<Instance> annotations) {
        this.annotations = annotations;
    }

    @Transient
    public String getValueDefinition() {
        return JavaVariable.getConstant(this.value);
    }

    @Transient
    public static String getConstant(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return value.toString();
    }

    @Transient
    public PropertyDescriptor getPropertyDescriptor() {
        try {
            Method readMethod = JavaVariable.class.getDeclaredMethod("getValue", new Class[0]);
            Method writeMethod = JavaVariable.class.getDeclaredMethod("setValue", Object.class);
            PropertyDescriptor descriptor = new PropertyDescriptor(this.name, readMethod, writeMethod);
            return descriptor;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.getDefinition(true) + " = " + this.getValueDefinition();
    }
}

