/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.code.ClassReader;
import com.intersult.code.Instance;
import com.intersult.code.JavaClass;
import com.intersult.code.JavaMethod;
import com.intersult.code.JavaVariable;
import com.intersult.code.Scope;
import com.intersult.util.bean.Default;
import com.intersult.util.bean.Key;
import com.intersult.util.bean.Name;
import com.intersult.util.bean.Required;
import com.intersult.util.bean.Transient;
import com.intersult.util.collection.ChainMap;
import com.intersult.util.string.Base64;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class Reflector {
    public static final String PACKAGE_JAVA_LANG = "java.lang";
    public static final String JAVASSIST_PROXY = "javassist.util.proxy.ProxyObject";
    public static final Reflector INSTANCE = new Reflector();
    private Map<String, JavaClass> rawMap = new HashMap<String, JavaClass>();
    private Map<String, JavaClass> parameterizedMap = new HashMap<String, JavaClass>();
    private boolean unproxy = true;
    public final JavaClass WILDCARD = new JavaClass(null, "?", JavaClass.Definition.WILDCARD);
    public final JavaClass OBJECT = this.reflect((Type)((Object)Object.class));
    public final JavaClass STRING = this.reflect((Type)((Object)String.class));
    public final JavaClass VOID = this.reflect((Type)((Object)Void.class));
    public final JavaClass ATOMIC_VOID = this.reflect((Type)Void.TYPE);
    public final JavaClass SHORT = this.reflect((Type)((Object)Short.class));
    public final JavaClass ATOMIC_SHORT = this.reflect((Type)Short.TYPE);
    public final JavaClass INTEGER = this.reflect((Type)((Object)Integer.class));
    public final JavaClass ATOMIC_INTEGER = this.reflect(Integer.TYPE, false);
    public final JavaClass LONG = this.reflect((Type)((Object)Long.class));
    public final JavaClass ATOMIC_LONG = this.reflect((Type)Long.TYPE);
    public final JavaClass BOOLEAN = this.reflect((Type)((Object)Boolean.class));
    public final JavaClass ATOMIC_BOOLEAN = this.reflect((Type)Boolean.TYPE);
    public final JavaClass BYTE = this.reflect((Type)((Object)Byte.class));
    public final JavaClass ATOMIC_BYTE = this.reflect((Type)Byte.TYPE);
    public final JavaClass DOUBLE = this.reflect((Type)((Object)Double.class));
    public final JavaClass ATOMIC_DOUBLE = this.reflect((Type)Double.TYPE);
    public final JavaClass FLOAT = this.reflect((Type)((Object)Float.class));
    public final JavaClass ATOMIC_FLOAT = this.reflect((Type)Float.TYPE);
    public final JavaClass BIG_DECIMAL = this.reflect((Type)((Object)BigDecimal.class));
    public final JavaClass CLASS = this.reflect((Type)((Object)Class.class));
    public final JavaClass DATE = this.reflect((Type)((Object)Date.class), false);
    public final JavaClass URI = this.reflect((Type)((Object)URI.class), false);
    public final JavaClass URL = this.reflect((Type)((Object)URL.class), false);
    public final JavaClass QNAME = this.reflect((Type)((Object)QName.class), false);
    public final JavaClass LIST = this.reflect((Type)((Object)List.class), false);
    public final JavaClass COLLECTION = this.reflect((Type)((Object)Collection.class), false);
    public final JavaClass SET = this.reflect((Type)((Object)Set.class), false);
    public final JavaClass MAP = this.reflect((Type)((Object)Map.class), false);
    public final JavaClass SERIALIZABLE = this.reflect((Type)((Object)Serializable.class), false);
    public final JavaClass BASE64 = this.reflect((Type)((Object)Base64.class));
    public final JavaClass ENUM = this.reflect((Type)((Object)Enum.class));
    public final JavaClass OVERRIDE = this.reflect((Type)((Object)Override.class));
    public final JavaClass REQUIRED = this.reflect((Type)((Object)Required.class));
    public final JavaClass DEFAULT = this.reflect((Type)((Object)Default.class));
    public final JavaClass NAME = this.reflect((Type)((Object)Name.class), false);
    public final JavaClass KEY = this.reflect((Type)((Object)Key.class));
    public final JavaClass TRANSIENT = this.reflect((Type)((Object)Transient.class));

    public boolean isUnproxy() {
        return this.unproxy;
    }

    public void setUnproxy(boolean unproxy) {
        this.unproxy = unproxy;
    }

    public List<JavaClass> reflect(Type ... types) {
        Context context = new Context();
        List<JavaClass> javaClassList = this.reflect(context, types);
        this.reflectMembers(context);
        return javaClassList;
    }

    private List<JavaClass> reflect(Context context, Type ... types) {
        ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>();
        for (Type type : types) {
            javaClasses.add(this.reflect(context, type));
        }
        return javaClasses;
    }

    public JavaClass reflect(Type type, boolean escape) {
        JavaClass javaClass = this.reflect(type);
        javaClass.setEscape(escape);
        return javaClass;
    }

    public JavaClass reflect(Type type) {
        Context context = new Context();
        if (this.unproxy) {
            type = Reflector.unproxy(type);
        }
        JavaClass javaClass = this.reflect(context, type);
        this.reflectMembers(context);
        return javaClass;
    }

    private JavaClass reflect(Context context, Type type) {
        if (type instanceof Class) {
            return this.reflect(context, (Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.reflect(context, (ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return this.reflect(context, (WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return this.reflect(context, (TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return this.reflect(context, (GenericArrayType)type);
        }
        throw new IllegalArgumentException("Illegal class type '" + type.getClass().getName() + "'");
    }

    private JavaClass reflect(Context context, Class<?> type) {
        String qualifiedName = type.getName();
        JavaClass javaClass = this.rawMap.get(qualifiedName);
        if (javaClass == null) {
            if (type.isArray()) {
                javaClass = this.reflect(context, type.getComponentType()).clone();
                javaClass.setArray(true);
                this.rawMap.put(qualifiedName, javaClass);
            } else {
                javaClass = Reflector.createClass(type, Reflector.getSimpleName(type));
                javaClass.setAbstract(Modifier.isAbstract(type.getModifiers()));
                javaClass.setStatic(Modifier.isStatic(type.getModifiers()));
                javaClass.setFinal(Modifier.isFinal(type.getModifiers()));
                context.getTypeMap().put(type, javaClass);
                this.rawMap.put(qualifiedName, javaClass);
                Reflector.reflectPackage(javaClass, type);
                this.reflectSuperclass(context, javaClass, type);
                this.reflectInterfaces(context, javaClass, type);
                if (type.getEnclosingClass() != null) {
                    javaClass.setParent(this.reflect(context, type.getEnclosingClass()));
                }
                this.reflectSubClasses(context, javaClass, type.getClasses());
                if (type.isEnum()) {
                    this.reflectEnum(context, javaClass, type);
                }
                javaClass.addAnnotations(this.reflectAnnotations(context, type.getAnnotations()));
                javaClass.setTypeParameters(this.reflect(context, (Type[])type.getTypeParameters()));
            }
            javaClass.freeze();
        }
        return javaClass;
    }

    public static String getSimpleName(Class<?> type) {
        int index;
        String name = type.getSimpleName();
        if ("".equals(name) && (index = (name = type.getName()).lastIndexOf(46)) >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private void reflectSuperclass(Context context, JavaClass javaClass, Class<?> type) {
        if (type.getSuperclass() != null && !Object.class.equals(type.getSuperclass())) {
            javaClass.setExtendsClass(this.reflect(context, type.getSuperclass()));
        }
    }

    private void reflectInterfaces(Context context, JavaClass javaClass, Class<?> type) {
        for (Class<?> interfaceType : type.getInterfaces()) {
            javaClass.getImplementsClasses().add(this.reflect(context, interfaceType));
        }
    }

    private void reflectSubClasses(Context context, JavaClass javaClass, Class<?>[] classes) {
        for (Class<?> type : classes) {
            this.reflect(context, type);
        }
    }

    private <E extends Enum<E>> void reflectEnum(Context context, JavaClass javaClass, Class<E> type) {
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            javaClass.getEnumConstants().add(constant.name());
        }
    }

    private void reflectMembers(Context parent) {
        while (!parent.getTypeMap().isEmpty()) {
            Context context = new Context();
            for (Map.Entry<Class<?>, JavaClass> entry : parent.getTypeMap().entrySet()) {
                this.reflectMembers(context, entry.getKey(), entry.getValue());
            }
            parent = context;
        }
    }

    private void reflectMembers(Context context, Class<?> type, JavaClass javaClass) {
        if (type.getPackage() == null || type.getPackage().getName().startsWith("java.")) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            this.reflectField(context, javaClass, field);
        }
        ClassReader<?> classReader = ClassReader.get(type);
        for (ClassReader.MethodInfo<?> methodInfo : classReader.getMethods().values()) {
            this.reflectMethod(context, javaClass, methodInfo);
        }
    }

    private void reflectField(Context context, JavaClass javaClass, Field field) {
        JavaClass fieldType = this.reflect(context, field.getGenericType());
        JavaVariable javaVariable = new JavaVariable(fieldType, field.getName());
        javaVariable.setStatic(Modifier.isStatic(field.getModifiers()));
        javaClass.addField(javaVariable);
    }

    private void reflectMethod(Context context, JavaClass javaClass, ClassReader.MethodInfo<?> methodInfo) {
        JavaMethod javaMethod = null;
        if (methodInfo.getType() == ClassReader.MethodInfo.MethodType.CONSTRUCTOR) {
            javaMethod = javaClass.addConstructor();
            Constructor<?> constructor = methodInfo.getConstructor();
            this.reflectMethodParameters(context, javaMethod, constructor.getGenericParameterTypes(), methodInfo.getParameterNames());
            javaMethod.addAnnotations(this.reflectAnnotations(context, constructor.getAnnotations()));
        } else if (methodInfo.getType() == ClassReader.MethodInfo.MethodType.METHOD) {
            javaMethod = javaClass.addMethod(methodInfo.getName());
            Method method = methodInfo.getMethod();
            javaMethod.setReturnType(this.reflect(context, method.getGenericReturnType()));
            this.reflectMethodParameters(context, javaMethod, method.getGenericParameterTypes(), methodInfo.getParameterNames());
            javaMethod.addAnnotations(this.reflectAnnotations(context, method.getAnnotations()));
            Instance nameAnnotation = javaMethod.getAnnotations().get(this.NAME);
            if (nameAnnotation != null) {
                javaMethod.setAnnotatedName((String)nameAnnotation.get("value").getValue());
            }
        }
        if (javaMethod != null) {
            javaMethod.setPrivate(Modifier.isPrivate(methodInfo.getModifiers()));
            javaMethod.setStatic(Modifier.isStatic(methodInfo.getModifiers()));
        }
    }

    private void reflectMethodParameters(Context context, JavaMethod javaMethod, Type[] parameterTypes, String[] parameterNames) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            String parameterName;
            JavaClass parameterClass = this.reflect(context, parameterTypes[i]);
            String string = parameterName = parameterNames == null ? null : parameterNames[i];
            if (parameterName == null) {
                parameterName = "arg" + i;
            }
            javaMethod.getParameters().add(new JavaVariable(parameterClass, parameterName));
        }
    }

    private List<Instance> reflectAnnotations(Context context, Annotation[] annotations) {
        ArrayList<Instance> annotationInstances = new ArrayList<Instance>();
        for (Annotation annotation : annotations) {
            Instance annotationInstance = this.reflectAnnotation(context, annotation);
            annotationInstances.add(annotationInstance);
        }
        return annotationInstances;
    }

    private Instance reflectAnnotation(Context context, Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        JavaClass annotationType = this.reflect(context, type);
        Instance annotationInstance = annotationType.newInstance();
        for (JavaVariable variable : annotationInstance.getVariables()) {
            try {
                Method method = type.getMethod(variable.getName(), new Class[0]);
                variable.setInit(method.getDefaultValue());
                variable.setValue(method.invoke((Object)annotation, new Object[0]));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return annotationInstance;
    }

    private JavaClass reflect(Context context, ParameterizedType type) {
        String qualifiedName = type.toString();
        JavaClass javaClass = this.parameterizedMap.get(qualifiedName);
        if (javaClass == null) {
            JavaClass rawClass = this.reflect(context, (Class)type.getRawType());
            List<JavaClass> parameters = this.reflect(context, type.getActualTypeArguments());
            javaClass = rawClass.parameterize(parameters);
            this.parameterizedMap.put(qualifiedName, javaClass);
            javaClass.freeze();
        }
        return javaClass;
    }

    private JavaClass reflect(Context context, WildcardType type) {
        JavaClass javaClass = Reflector.createClass(type, "?");
        for (Type bound : type.getLowerBounds()) {
            javaClass.getLowerBounds().add(this.reflect(context, bound));
        }
        for (Type bound : type.getUpperBounds()) {
            if (Object.class.equals((Object)bound)) continue;
            javaClass.getUpperBounds().add(this.reflect(context, bound));
        }
        return javaClass;
    }

    private JavaClass reflect(Context context, TypeVariable<?> type) {
        JavaClass javaClass = (JavaClass)context.getVariableMap().get((Object)type.getName());
        if (javaClass == null) {
            javaClass = Reflector.createClass(type, type.getName());
            context.getVariableMap().put((Object)type.getName(), (Object)javaClass);
            for (Type bound : type.getBounds()) {
                if (Object.class.equals((Object)bound)) continue;
                javaClass.getUpperBounds().add(this.reflect(context, bound));
            }
            javaClass.freeze();
        }
        return javaClass;
    }

    private JavaClass reflect(Context context, GenericArrayType type) {
        String qualifiedName = type.toString();
        JavaClass javaClass = this.rawMap.get(type);
        if (javaClass == null) {
            javaClass = this.reflect(context, type.getGenericComponentType()).clone();
            javaClass.setArray(true);
            this.rawMap.put(qualifiedName, javaClass);
            javaClass.freeze();
        }
        return javaClass;
    }

    private static JavaClass createClass(Type type, String name) {
        JavaClass javaClass = new JavaClass(null, name);
        javaClass.setDefinition(JavaClass.Definition.fromType(type));
        return javaClass;
    }

    private static void reflectPackage(JavaClass javaClass, Class<?> classType) {
        Package classPackage = classType.getPackage();
        if (classPackage == null) {
            javaClass.setKeepCase(true);
            javaClass.setEscape(false);
        } else {
            javaClass.setPackage(classPackage.getName());
        }
    }

    public JavaClass parameterize(JavaClass javaClass, Type ... types) {
        List<JavaClass> parameters = this.reflect(types);
        return javaClass.parameterize(parameters);
    }

    public void makeSerializable(JavaClass javaClass, long serialVersionUID) {
        javaClass.getImplementsClasses().add(this.SERIALIZABLE);
        JavaVariable serialVersionUIDVariable = new JavaVariable(this.ATOMIC_LONG, "serialVersionUID");
        serialVersionUIDVariable.setStatic(true);
        serialVersionUIDVariable.setFinal(true);
        serialVersionUIDVariable.setSkipNameCorrection(true);
        serialVersionUIDVariable.setInit(serialVersionUID);
        javaClass.addField(serialVersionUIDVariable);
    }

    public Scope simpleScope(Object value, String name) {
        Scope scope = new Scope();
        scope.add(this.reflectVariable(name, value));
        return scope;
    }

    public JavaVariable reflectVariable(String name, Object value) {
        Object init;
        JavaClass javaClass;
        if (value == null) {
            javaClass = this.OBJECT;
            init = null;
        } else {
            javaClass = this.reflect((Type)value.getClass());
            init = value;
        }
        JavaVariable javaVariable = new JavaVariable(javaClass, name);
        javaVariable.setInit(init);
        return javaVariable;
    }

    public static Type unproxy(Type type) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            for (Class<?> interfaceClass : classType.getInterfaces()) {
                if (!JAVASSIST_PROXY.equals(interfaceClass.getName())) continue;
                return classType.getSuperclass();
            }
        }
        return type;
    }

    private static class Context {
        private ChainMap<String, JavaClass> variableMap = new ChainMap();
        private Map<Class<?>, JavaClass> typeMap = new LinkedHashMap();

        public ChainMap<String, JavaClass> getVariableMap() {
            return this.variableMap;
        }

        public Map<Class<?>, JavaClass> getTypeMap() {
            return this.typeMap;
        }
    }
}

