/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.code;

import com.intersult.code.JavaVariable;
import com.intersult.util.bean.Transient;
import com.intersult.util.string.DelimiterStringBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Scope {
    private List<JavaVariable> variableList = new ArrayList<JavaVariable>();
    private Map<String, JavaVariable> variableMap = new LinkedHashMap<String, JavaVariable>();

    public void add(JavaVariable variable) {
        String name = variable.getVariableName();
        if (this.contains(name)) {
            throw new IllegalArgumentException("Variable '" + name + "' already exists");
        }
        this.variableList.add(variable);
        this.variableMap.put(name, variable);
    }

    public boolean contains(String name) {
        return this.variableMap.containsKey(name);
    }

    public JavaVariable get(String name) {
        return this.variableMap.get(name);
    }

    public List<JavaVariable> getVariables() {
        return this.variableList;
    }

    public int size() {
        return this.variableList.size();
    }

    @Transient
    public String getFormalDefinition() {
        DelimiterStringBuilder buffer = new DelimiterStringBuilder(", ");
        for (JavaVariable variable : this.variableList) {
            buffer.append(variable.getDefinition(false));
        }
        return buffer.toString();
    }

    @Transient
    public String getAssignDefinition() {
        DelimiterStringBuilder buffer = new DelimiterStringBuilder(", ");
        for (JavaVariable variable : this.variableList) {
            if (variable.getValue() == null) continue;
            buffer.append(variable.getAssignment());
        }
        return buffer.toString();
    }

    public List<JavaVariable> getAssigned() {
        ArrayList<JavaVariable> assigned = new ArrayList<JavaVariable>();
        for (JavaVariable variable : this.variableList) {
            if (variable.getValue() == null) continue;
            assigned.add(variable);
        }
        return assigned;
    }

    @Transient
    public String getActualDefinition() {
        DelimiterStringBuilder buffer = new DelimiterStringBuilder(", ");
        for (JavaVariable variable : this.variableList) {
            buffer.append(variable.getValueDefinition());
        }
        return buffer.toString();
    }

    @Transient
    public String getReferenceDefinion() {
        DelimiterStringBuilder buffer = new DelimiterStringBuilder(", ");
        for (JavaVariable variable : this.variableList) {
            buffer.append(variable.getVariableName());
        }
        return buffer.toString();
    }

    public List<Class<?>> getTypes() {
        ArrayList types = new ArrayList();
        for (JavaVariable variable : this.variableList) {
            types.add(variable.getType().getType());
        }
        return types;
    }

    public List<Object> getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (JavaVariable variable : this.variableList) {
            values.add(variable.getValue());
        }
        return values;
    }

    public String toString() {
        return this.getActualDefinition();
    }
}

