/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.parser;

import com.intersult.parser.ParseNode;
import com.intersult.parser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class Scanner {
    private Map<String, ParseNode> cache = new HashMap<String, ParseNode>();
    private String source;
    protected int position;
    private Parser error;
    private int errorPosition;

    public Scanner() {
        this.reset();
    }

    public Scanner(String source) {
        this();
        if (source == null) {
            throw new NullPointerException("No input given to parse");
        }
        this.source = source;
    }

    public void reset() {
        this.position = 0;
        this.errorPosition = -1;
        this.cache.clear();
    }

    public int peek() {
        return this.position < this.source.length() ? (int)this.source.charAt(this.position) : -1;
    }

    public int read() {
        return this.position < this.source.length() ? (int)this.source.charAt(this.position++) : -1;
    }

    public String peek(int length) {
        return this.position + length <= this.source.length() ? this.source.substring(this.position, this.position + length) : null;
    }

    public String read(int length) {
        return this.position + length <= this.source.length() ? this.source.substring(this.position, this.position += length) : null;
    }

    public void skip(int length) {
        this.position += length;
    }

    public boolean readLine(InputStream stream) throws IOException {
        return this.readLine(Scanner.readLineString(System.in));
    }

    public boolean readLine(String source) {
        this.reset();
        this.source = source;
        return source != null;
    }

    public static String readLineString(InputStream stream) throws IOException {
        int c;
        StringBuilder result = null;
        boolean start = true;
        while ((c = stream.read()) != 0) {
            if (c == 10 || c == 13) {
                if (!start) break;
                continue;
            }
            start = false;
            if (result == null) {
                result = new StringBuilder();
            }
            result.append((char)c);
        }
        return result == null ? null : result.toString();
    }

    public void error(Parser parser, int resetPosition) {
        if (resetPosition >= this.errorPosition && parser.name().charAt(0) != '_') {
            this.error = parser;
            this.errorPosition = resetPosition;
        }
        this.position = resetPosition;
    }

    public String error() {
        return this.error == null ? null : this.toString(this.errorPosition, "expecting " + this.error.name());
    }

    public void position(int position) {
        this.position = position;
    }

    public boolean cacheContains(String parser) {
        return this.cache.containsKey(parser + "/" + this.position);
    }

    public ParseNode cacheGet(String parser) {
        return this.cache.get(parser + "/" + this.position);
    }

    public void cachePut(String parser, int startPosition, ParseNode node) {
        this.cache.put(parser + "/" + startPosition, node);
    }

    public String toString() {
        return this.toString(this.position, "POS");
    }

    public String toString(int position, String message) {
        return this.source.substring(0, position) + "<" + message + ">" + (position < this.source.length() ? this.source.substring(position) : "");
    }

    public void cacheDump(PrintStream stream) {
        stream.println("Scanner cache:");
        for (Map.Entry<String, ParseNode> entry : this.cache.entrySet()) {
            stream.println(entry.getKey() + " := " + (entry.getValue() == null ? "<null>" : entry.getValue().value()));
        }
    }
}

