/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.rsocket;

import com.jauntsdn.rsocket.Attributes;
import com.jauntsdn.rsocket.Availability;
import com.jauntsdn.rsocket.Message;
import com.jauntsdn.rsocket.MessageStreams;
import com.jauntsdn.rsocket.MessageStreamsHandler;
import com.jauntsdn.rsocket.RSocket;
import com.jauntsdn.rsocket.RSocketHandler;
import io.netty.buffer.ByteBufAllocator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import java.util.Optional;
import org.reactivestreams.Publisher;

public class RSocketProxy
implements RSocket,
RSocketHandler {
    protected final MessageStreams source;

    public RSocketProxy(MessageStreams source) {
        this.source = source;
    }

    @Override
    public Completable fireAndForget(Message message) {
        return this.source.fireAndForget(message);
    }

    @Override
    public Single<Message> requestResponse(Message message) {
        return this.source.requestResponse(message);
    }

    @Override
    public Flowable<Message> requestStream(Message message) {
        return this.source.requestStream(message);
    }

    @Override
    public Flowable<Message> requestChannel(Publisher<Message> messages) {
        return this.source.requestChannel(messages);
    }

    @Override
    public Flowable<Message> requestChannel(Message message, Publisher<Message> messages) {
        MessageStreams s = this.source;
        if (s instanceof MessageStreamsHandler) {
            return ((MessageStreamsHandler)s).requestChannel(message, messages);
        }
        return s.requestChannel(messages);
    }

    @Override
    public Optional<Message.Factory> messageFactory() {
        return this.source.messageFactory();
    }

    @Override
    public Optional<Scheduler> scheduler() {
        return this.source.scheduler();
    }

    @Override
    public Optional<Scheduler> coarseScheduler() {
        MessageStreams s = this.source;
        if (s instanceof RSocket) {
            return ((RSocket)s).coarseScheduler();
        }
        return Optional.empty();
    }

    @Override
    public Optional<ByteBufAllocator> allocator() {
        return this.source.allocator();
    }

    @Override
    public void dispose() {
        this.source.dispose();
    }

    @Override
    public void dispose(String reason, boolean isGraceful) {
        this.source.dispose(reason, isGraceful);
    }

    @Override
    public boolean isDisposed() {
        return this.source.isDisposed();
    }

    @Override
    public Completable onClose() {
        return this.source.onClose();
    }

    public Attributes attributes() {
        return this.source.attributes();
    }

    @Override
    public Completable metadataPush(Message message) {
        MessageStreams s = this.source;
        if (s instanceof RSocket) {
            return ((RSocket)s).metadataPush(message);
        }
        message.release();
        return Completable.error((Throwable)new UnsupportedOperationException("metadata-push is not supported by source: " + s.getClass().getName()));
    }

    @Override
    public double availability(int rank) {
        MessageStreams s = this.source;
        if (s instanceof RSocket) {
            return ((RSocket)s).availability(rank);
        }
        return s.isDisposed() ? 0.0 : 1.0;
    }

    public Optional<Availability.AvailabilityListener> onAvailability() {
        MessageStreams s = this.source;
        if (s instanceof RSocket) {
            return ((RSocket)s).onAvailability();
        }
        return Optional.empty();
    }
}

