/*
 * Decompiled with CFR 0.152.
 */
package scriptella.tools.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import scriptella.interactive.ConsoleProgressIndicator;
import scriptella.interactive.ProgressIndicator;
import scriptella.tools.ant.EtlTaskBase;
import scriptella.tools.launcher.EtlLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EtlExecuteTask
extends EtlTaskBase {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private final EtlLauncher launcher = new EtlLauncher();
    private String maxmemory;
    private boolean fork;
    private boolean nostat;

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public boolean isNostat() {
        return this.nostat;
    }

    public void setNostat(boolean nostat) {
        this.nostat = nostat;
    }

    public String getMaxmemory() {
        return this.maxmemory;
    }

    public void setMaxmemory(String maxmemory) {
        this.maxmemory = maxmemory;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setFile(String fileName) throws FileNotFoundException {
        FileSet f = new FileSet();
        f.setFile(this.launcher.resolveFile(null, fileName));
        this.filesets.add(f);
    }

    public void execute() throws BuildException {
        ArrayList<File> files = new ArrayList<File>();
        try {
            if (this.filesets.isEmpty()) {
                files.add(this.launcher.resolveFile(this.getProject().getBaseDir(), null));
            } else {
                for (FileSet fs : this.filesets) {
                    String[] srcFiles;
                    DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                    File srcDir = fs.getDir(this.getProject());
                    for (String fName : srcFiles = ds.getIncludedFiles()) {
                        File file = this.launcher.resolveFile(srcDir, fName);
                        files.add(file);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        if (this.fork) {
            this.fork(files);
        } else {
            this.execute(files);
        }
    }

    private void execute(List<File> files) {
        this.launcher.setProgressIndicator((ProgressIndicator)new ConsoleProgressIndicator());
        this.launcher.setProperties(this.getProperties());
        this.launcher.setNoStat(this.nostat);
        this.setupLogging();
        for (File file : files) {
            try {
                this.launcher.execute(file);
            }
            catch (Exception e) {
                throw new BuildException("Unable to execute file " + file + ": " + e.getMessage(), (Throwable)e);
            }
        }
        this.resetLogging();
    }

    private void fork(List<File> files) {
        int r;
        Java j = new Java();
        j.setFork(true);
        j.setProject(this.getProject());
        j.setClassname(EtlLauncher.class.getName());
        StringBuilder line = new StringBuilder();
        if (this.nostat) {
            line.append("-nostat ");
        }
        for (File file : files) {
            line.append(file.getPath()).append(' ');
        }
        j.createArg().setLine(line.toString());
        if (this.maxmemory != null) {
            j.setMaxmemory(this.maxmemory);
        }
        if ((r = j.executeJava()) != 0) {
            throw new BuildException("Unable to execute files: " + files + ". See error log.");
        }
    }
}

