/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.opencsv.reader;

import com.javaquery.helper.BatchProcessor;
import com.javaquery.opencsv.reader.CsvRowTransformer;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class CsvReader<T> {
    private File source;
    private char delimiter = (char)44;
    private char quoteChar = (char)34;
    private char escapeChar = (char)92;
    private int skipLines = 0;
    private CsvRowTransformer<T> rowTransformer;
    private BatchProcessor<T> batchProcessor;
    private int batchSize = 1000;

    private CsvReader() {
    }

    public static <T> CsvReader<T> builder() {
        return new CsvReader<T>();
    }

    public CsvReader<T> source(File source) {
        this.source = source;
        return this;
    }

    public CsvReader<T> delimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public CsvReader<T> quoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public CsvReader<T> escapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    public CsvReader<T> skipLines(int skipLines) {
        if (skipLines < 0) {
            throw new IllegalArgumentException("Skip lines must be non-negative");
        }
        this.skipLines = skipLines;
        return this;
    }

    public CsvReader<T> rowTransformer(CsvRowTransformer<T> rowTransformer) {
        this.rowTransformer = rowTransformer;
        return this;
    }

    public CsvReader<T> batchProcessor(BatchProcessor<T> batchProcessor) {
        this.batchProcessor = batchProcessor;
        return this;
    }

    public CsvReader<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public void read() throws IOException {
        this.validateInputs();
        int currentBatchCount = 0;
        int batchNumber = 0;
        int totalProcessed = 0;
        String[] headers = null;
        ArrayList transformedBatch = new ArrayList(this.batchSize);
        Object previousRow = null;
        try (BufferedReader br = new BufferedReader(new FileReader(this.source.getAbsoluteFile()));
             CSVReader reader = this.buildCsvReader(br);){
            String[] line;
            while ((line = reader.readNext()) != null) {
                Object transformed;
                if (headers == null) {
                    headers = line;
                    continue;
                }
                previousRow = transformed = this.rowTransformer.transform(headers, line, previousRow);
                if (transformed != null) {
                    transformedBatch.add(transformed);
                    if (++currentBatchCount >= this.batchSize) {
                        this.batchProcessor.onBatch(transformedBatch);
                        totalProcessed += currentBatchCount;
                        ++batchNumber;
                        transformedBatch.clear();
                        currentBatchCount = 0;
                    }
                }
                line = null;
            }
            if (currentBatchCount > 0) {
                this.batchProcessor.onBatch(transformedBatch);
                totalProcessed += currentBatchCount;
                ++batchNumber;
            }
            this.batchProcessor.onComplete(totalProcessed, batchNumber);
        }
        catch (CsvValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateInputs() {
        if (this.source == null) {
            throw new IllegalArgumentException("Source file must be provided");
        }
        if (this.rowTransformer == null) {
            throw new IllegalArgumentException("Row transformer must be provided");
        }
        if (this.batchProcessor == null) {
            throw new IllegalArgumentException("Batch processor must be provided");
        }
    }

    private CSVReader buildCsvReader(BufferedReader br) {
        CSVParserBuilder parserBuilder = new CSVParserBuilder().withSeparator(this.delimiter).withQuoteChar(this.quoteChar).withEscapeChar(this.escapeChar);
        return new CSVReaderBuilder((Reader)br).withCSVParser((ICSVParser)parserBuilder.build()).withSkipLines(this.skipLines).build();
    }
}

