/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.opencsv.writer;

import com.javaquery.annotations.Exportable;
import com.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;

public class CsvWriter<T> {
    private List<String> headers;
    private List<String> keys;
    private Iterable<T> data;
    private File destination;
    private char delimiter = (char)44;
    private char quotechar = (char)34;
    private char escapechar = (char)34;
    private String lineEnd = "\n";
    private boolean includeHeader = true;

    private CsvWriter() {
    }

    public static <T> CsvWriter<T> builder() {
        return new CsvWriter<T>();
    }

    public CsvWriter<T> headers(List<String> headers) {
        this.headers = headers;
        return this;
    }

    public CsvWriter<T> keys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    public CsvWriter<T> data(Iterable<T> data) {
        this.data = data;
        return this;
    }

    public CsvWriter<T> toFile(File destination) {
        this.destination = destination;
        return this;
    }

    public CsvWriter<T> delimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public CsvWriter<T> quoteChar(char quotechar) {
        this.quotechar = quotechar;
        return this;
    }

    public CsvWriter<T> escapeChar(char escapechar) {
        this.escapechar = escapechar;
        return this;
    }

    public CsvWriter<T> lineEnd(String lineEnd) {
        this.lineEnd = lineEnd;
        return this;
    }

    public CsvWriter<T> includeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
        return this;
    }

    public void write() throws IOException {
        if (this.data == null || this.data.spliterator().getExactSizeIfKnown() <= 0L) {
            return;
        }
        if (this.includeHeader && (this.headers == null || this.headers.isEmpty())) {
            throw new IllegalArgumentException("Headers must be provided when includeHeader is true");
        }
        if (!this.includeHeader && (this.keys == null || this.keys.isEmpty())) {
            throw new IllegalArgumentException("Keys must be provided when includeHeader is false");
        }
        if (this.includeHeader && this.headers.size() != this.keys.size()) {
            throw new IllegalArgumentException("Headers and Keys size must be same");
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.destination));
             CSVWriter writer = new CSVWriter((Writer)bw, this.delimiter, this.quotechar, this.escapechar, this.lineEnd);){
            if (this.includeHeader) {
                writer.writeNext(this.headers.toArray(new String[0]));
            }
            for (T item : this.data) {
                int maxSubRows = 1;
                for (String key : this.keys) {
                    if (!key.contains(".")) continue;
                    String[] parts = key.split("\\.", 2);
                    Field field = this.getField(item.getClass(), parts[0]);
                    if (field == null || !List.class.isAssignableFrom(field.getType()) && !Set.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object collectionObj = field.get(item);
                    int size = 0;
                    if (collectionObj instanceof List) {
                        size = ((List)collectionObj).size();
                    } else if (collectionObj instanceof Set) {
                        size = ((Set)collectionObj).size();
                    }
                    if (size <= maxSubRows) continue;
                    maxSubRows = size;
                }
                int keysSize = this.keys.size();
                for (int subRow = 0; subRow < maxSubRows; ++subRow) {
                    String[] row = new String[keysSize];
                    for (int colIdx = 0; colIdx < keysSize; ++colIdx) {
                        String key = this.keys.get(colIdx);
                        if (key.contains(".")) {
                            String[] parts = key.split("\\.", 2);
                            Field field = this.getField(item.getClass(), parts[0]);
                            if (field != null && (List.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(field.getType()))) {
                                Set subSet;
                                field.setAccessible(true);
                                Object collectionObj = field.get(item);
                                Object subItem = null;
                                if (collectionObj instanceof List) {
                                    List subList = (List)collectionObj;
                                    if (subRow < subList.size()) {
                                        subItem = subList.get(subRow);
                                    }
                                } else if (collectionObj instanceof Set && subRow < (subSet = (Set)collectionObj).size()) {
                                    subItem = subSet.stream().skip(subRow).findFirst().orElse(null);
                                }
                                Object value = this.getNestedFieldValue(subItem, parts[1]);
                                row[colIdx] = value != null ? value.toString() : "";
                                continue;
                            }
                            Object value = this.getNestedFieldValue(item, key);
                            row[colIdx] = value != null ? value.toString() : "";
                            continue;
                        }
                        Object value = this.getNestedFieldValue(item, key);
                        row[colIdx] = value != null ? value.toString() : "";
                    }
                    writer.writeNext(row);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Field getField(Class<?> clazz, String fieldName) {
        for (Field field : clazz.getDeclaredFields()) {
            Exportable exp = field.getAnnotation(Exportable.class);
            if (exp == null || !exp.key().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private Object getNestedFieldValue(Object obj, String keyPath) {
        try {
            String[] parts = keyPath.split("\\.", 2);
            Field field = this.getField(obj.getClass(), parts[0]);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            Object value = field.get(obj);
            if (parts.length == 1) {
                return value;
            }
            if (value != null) {
                return this.getNestedFieldValue(value, parts[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

