/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.spring.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.javaquery.util.time.DatePattern;
import com.javaquery.util.time.DateTimeFormat;
import com.javaquery.util.time.LocalDates;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class LocalDateTimeJsonDeserializer
extends JsonDeserializer<LocalDateTime> {
    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String dateTimeString = p.getText().trim();
        try {
            return LocalDateTime.parse(dateTimeString);
        }
        catch (DateTimeParseException e1) {
            try {
                return LocalDates.parseLocalDateTime((String)dateTimeString, (DateTimeFormat)DatePattern.Y_M_D__HMS);
            }
            catch (DateTimeParseException e2) {
                try {
                    return LocalDate.parse(dateTimeString).atStartOfDay();
                }
                catch (DateTimeParseException e3) {
                    throw new IOException("Unable to parse date/datetime: " + dateTimeString + ". Expected formats: 'yyyy-MM-dd'T'HH:mm:ss', 'yyyy-MM-dd HH:mm:ss', or 'yyyy-MM-dd'", e3);
                }
            }
        }
    }
}

