/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.collection;

import com.javaquery.util.Objects;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Collections {
    private Collections() {
    }

    public static boolean nullOrEmpty(Collection<?> collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static boolean nonNullNonEmpty(Collection<?> collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static boolean nullOrEmpty(Map<?, ?> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static boolean nonNullNonEmpty(Map<?, ?> map) {
        return Objects.nonNull(map) && !map.isEmpty();
    }

    public static <T> Stream<List<T>> batches(List<T> source, int batchSize) {
        if (Objects.isNull(source)) {
            throw new IllegalArgumentException("source can not be null");
        }
        int size = source.size();
        if (batchSize < 0) {
            throw new IllegalArgumentException("batchSize can not be negative");
        }
        if (batchSize == 0 && size != 0) {
            return Stream.of(source);
        }
        if (size <= 0) {
            return Stream.empty();
        }
        int fullChunks = (size - 1) / batchSize;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * batchSize, n == fullChunks ? size : (n + 1) * batchSize));
    }
}

