/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.javaquery.util.UniqueIdGenerator;
import com.javaquery.util.logging.Action;
import com.javaquery.util.time.Dates;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExecutionContext<T> {
    @JsonProperty(value="request_id")
    private final String requestId;
    @JsonProperty(value="reference_id")
    private T referenceId;
    private final Action action;
    private Map<String, Object> meta;
    @JsonProperty(value="max_retries")
    private Integer maxRetries = 5;
    @JsonProperty(value="retries_attempted")
    private Integer retriesAttempted = 0;
    @JsonProperty(value="created_at")
    private final Date createdAt;

    public ExecutionContext(String requestId, T referenceId, Action action) {
        this.requestId = requestId;
        this.referenceId = referenceId;
        this.action = action;
        this.meta = new HashMap<String, Object>();
        this.createdAt = Dates.current();
    }

    public ExecutionContext(T referenceId, Action action) {
        this.requestId = UniqueIdGenerator.generate();
        this.referenceId = referenceId;
        this.action = action;
        this.meta = new HashMap<String, Object>();
        this.createdAt = Dates.current();
    }

    public ExecutionContext(Action action) {
        this.requestId = UniqueIdGenerator.generate();
        this.action = action;
        this.meta = new HashMap<String, Object>();
        this.createdAt = Dates.current();
    }

    public ExecutionContext(T referenceId, Action action, Integer maxRetries) {
        this.requestId = UniqueIdGenerator.generate();
        this.referenceId = referenceId;
        this.action = action;
        this.maxRetries = maxRetries;
        this.meta = new HashMap<String, Object>();
        this.createdAt = Dates.current();
    }

    public ExecutionContext(Action action, Integer maxRetries) {
        this.requestId = UniqueIdGenerator.generate();
        this.action = action;
        this.maxRetries = maxRetries;
        this.meta = new HashMap<String, Object>();
        this.createdAt = Dates.current();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public T getReferenceId() {
        return this.referenceId;
    }

    public Action getAction() {
        return this.action;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public Object getMeta(String key, Object defaultValue) {
        return this.meta.getOrDefault(key, defaultValue);
    }

    public void addMeta(String key, Object value) {
        this.meta.put(key, value);
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Integer getRetriesAttempted() {
        return this.retriesAttempted;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void addRetriesAttempted(Integer retriesAttempted) {
        ExecutionContext executionContext = this;
        executionContext.retriesAttempted = executionContext.retriesAttempted + retriesAttempted;
    }

    public String toString() {
        return "ExecutionContext{requestId='" + this.requestId + '\'' + ", referenceId=" + this.referenceId + ", action=" + this.action + ", maxRetries=" + this.maxRetries + ", retriesAttempted=" + this.retriesAttempted + ", createdAt=" + this.createdAt + '}';
    }
}

