/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.io;

import com.javaquery.util.Assert;
import com.javaquery.util.collection.Collections;
import com.javaquery.util.io.Files;
import com.javaquery.util.string.Strings;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class JFile
extends File {
    private final Map<String, String> attributes = new HashMap<String, String>();

    public JFile(String pathname) {
        super(pathname);
    }

    public String getExtension() {
        int lastIndexOfDot;
        String name = this.getName();
        if (Strings.nonNullNonEmpty(name) && (lastIndexOfDot = name.lastIndexOf(".")) > 0) {
            return name.substring(lastIndexOfDot + 1);
        }
        return "";
    }

    public JFile rename(String name) {
        boolean result;
        Assert.nonNull(name, NullPointerException::new);
        if (this.exists() && (result = this.renameTo(new File(this.getParent() + File.separatorChar + name)))) {
            return new JFile(this.getParent() + File.separatorChar + name);
        }
        return null;
    }

    public String read() {
        return Files.readFromFile(this);
    }

    public void write(String data) {
        Files.writeToFile(this, data);
    }

    public void append(String data, boolean appendNewLine) {
        Files.appendToFile(this, data, appendNewLine);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addAllAttribute(Map<String, String> attributes) {
        if (Collections.nonNullNonEmpty(attributes)) {
            this.attributes.putAll(attributes);
        }
    }

    public String optAttribute(String key, String defaultValue) {
        return this.attributes.getOrDefault(key, defaultValue);
    }
}

