/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.logging;

import com.javaquery.util.logging.Action;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public final class LogBuilder {
    public static final String ACTION = "action";
    public static final String MESSAGE = "message";
    public static final String TAGS = "tags";
    public static final String EXECUTION_TIME = "executionTime";
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final StringJoiner messageBuilder;
    private String message;
    private final List<String> tags = new ArrayList<String>();
    private long executionStartTime;

    public LogBuilder(Action action) {
        this.messageBuilder = new StringJoiner("\n");
        this.attributes.put(ACTION, action);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public LogBuilder put(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.attributes.get(key);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.put(MESSAGE, this.message);
    }

    public void buildMessage(Object message) {
        if (Objects.nonNull(message)) {
            this.messageBuilder.add(message.toString());
            this.setMessage(this.messageBuilder.toString());
        }
    }

    public void buildMessage(Object key, Object value) {
        if (Objects.nonNull(key) && Objects.nonNull(value)) {
            this.buildMessage(String.format("%s : %s", key, value));
        }
    }

    public void setExecutionStartTime() {
        this.executionStartTime = System.currentTimeMillis();
    }

    public void setExecutionEndTime() {
        if (this.executionStartTime != 0L) {
            this.attributes.put(EXECUTION_TIME, System.currentTimeMillis() - this.executionStartTime);
        }
    }

    public void addTag(String tag) {
        this.tags.add(tag);
        this.put(TAGS, this.tags);
    }
}

