/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util;

import com.javaquery.util.collection.Collections;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class Assert {
    private Assert() {
    }

    public static <T extends Throwable> void nonNull(Object object, Supplier<T> exceptionSupplier) throws T {
        if (Objects.isNull(object)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T extends Throwable> void isNull(Object object, Supplier<T> exceptionSupplier) throws T {
        if (Objects.nonNull(object)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T extends Throwable> void isTrue(boolean expression, Supplier<T> exceptionSupplier) throws T {
        if (!expression) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T extends Throwable> void isFalse(boolean expression, Supplier<T> exceptionSupplier) throws T {
        if (expression) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T extends Throwable> void nonNullNonEmpty(Collection<?> collection, Supplier<T> exceptionSupplier) throws T {
        if (Collections.nullOrEmpty(collection)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T extends Throwable> void nullOrEmpty(Collection<?> collection, Supplier<T> exceptionSupplier) throws T {
        if (Collections.nonNullNonEmpty(collection)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T extends Throwable> void nonNullNonEmptyMap(Map<?, ?> map, Supplier<T> exceptionSupplier) throws T {
        if (Collections.nullOrEmpty(map)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T extends Throwable> void nullOrEmptyMap(Map<?, ?> map, Supplier<T> exceptionSupplier) throws T {
        if (Collections.nonNullNonEmpty(map)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }
}

