/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util;

import java.util.Objects;
import java.util.regex.Pattern;

public final class Regex {
    public static final String REGEX_NUMBER = "^-?[0-9]\\d*(\\.\\d+)?$";
    public static final String REGEX_ALPHA_NUMERIC = "^[a-zA-Z0-9]*$";
    public static final String REGEX_EMAIL = "^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))[^_@!*]*?$";
    public static final Pattern EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))[^_@!*]*?$");

    private Regex() {
    }

    public static boolean isNumber(String value) {
        return Objects.nonNull(value) && value.matches(REGEX_NUMBER);
    }

    public static boolean isAlphaNumeric(String value) {
        return Objects.nonNull(value) && value.matches(REGEX_ALPHA_NUMERIC);
    }

    public static boolean isValidEmail(String value) {
        return Objects.nonNull(value) && EMAIL_PATTERN.matcher(value).matches();
    }
}

