/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.io;

import com.javaquery.util.Assert;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Files {
    private static final Logger LOGGER = LoggerFactory.getLogger(Files.class);
    public static final String SYSTEM_TMP_DIR = System.getProperty("java.io.tmpdir");
    public static final String CURRENT_WORKING_DIR = System.getProperty("user.dir");

    public static <T extends File> boolean createNewFile(T file) {
        Assert.nonNull(file, NullPointerException::new);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public static <T extends File> boolean deleteIfExists(T file) {
        return file.exists() && file.delete();
    }

    public static <T extends File> boolean deleteAndCreateNewFile(T file) {
        Assert.nonNull(file, NullPointerException::new);
        if (file.exists()) {
            file.delete();
        }
        return Files.createNewFile(file);
    }

    public static <T extends File> void writeToFile(T file, String data) {
        Assert.nonNull(file, NullPointerException::new);
        Assert.nonNull(data, NullPointerException::new);
        if (!file.exists()) {
            Files.createNewFile(file);
        }
        try {
            java.nio.file.Files.write(Files.getPath(file), data.getBytes(), new OpenOption[0]);
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static <T extends File> void appendToFile(T file, String data, boolean appendNewLine) {
        Assert.nonNull(file, NullPointerException::new);
        Assert.nonNull(data, NullPointerException::new);
        if (!file.exists()) {
            Files.createNewFile(file);
        }
        data = appendNewLine ? (String)data + "\n" : data;
        try {
            java.nio.file.Files.write(Files.getPath(file), ((String)data).getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static <T extends File> String readFromFile(T file) {
        Assert.nonNull(file, NullPointerException::new);
        if (file.exists()) {
            try {
                return new String(java.nio.file.Files.readAllBytes(Files.getPath(file)));
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private static <T extends File> Path getPath(T file) {
        return Paths.get(file.getAbsolutePath(), new String[0]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String loadResource(String path) {
        Assert.nonNull(path, NullPointerException::new);
        if (!path.trim().isEmpty()) {
            try (InputStream inputStream = this.getClass().getResourceAsStream(path);){
                String string;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String fileLine;
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((fileLine = bufferedReader.readLine()) != null) {
                        stringBuilder.append(fileLine);
                    }
                    string = stringBuilder.toString();
                }
                return string;
            }
            catch (IOException | NullPointerException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static String determineContentType(File file) {
        try {
            String contentType = java.nio.file.Files.probeContentType(file.toPath());
            return contentType != null ? contentType : "application/octet-stream";
        }
        catch (IOException e) {
            return "application/octet-stream";
        }
    }
}

